/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms.reliability;

import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.context.notification.ExceptionNotificationListener;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.context.notification.ExceptionNotification;
import org.mule.exception.DefaultSystemExceptionStrategy;
import org.mule.routing.filters.WildcardFilter;
import org.mule.transport.jms.redelivery.MessageRedeliveredException;
import org.mule.transport.jms.reliability.AbstractJmsReliabilityTestCase;
import org.mule.util.concurrent.Latch;

public class InboundMessageLossTestCase
extends AbstractJmsReliabilityTestCase {
    protected Latch messageRedelivered;
    protected final int latchTimeout = 5000;

    protected String getConfigResources() {
        return "reliability/activemq-config.xml, reliability/inbound-message-loss.xml";
    }

    @Override
    protected void doSetUp() throws Exception {
        super.doSetUp();
        ((DefaultSystemExceptionStrategy)muleContext.getExceptionListener()).setRollbackTxFilter(new WildcardFilter("*"));
        this.messageRedelivered = new Latch();
        muleContext.registerListener((ServerNotificationListener)new ExceptionNotificationListener<ExceptionNotification>(){

            public void onNotification(ExceptionNotification notification) {
                if (notification.getException() instanceof MessageRedeliveredException) {
                    InboundMessageLossTestCase.this.messageRedelivered.countDown();
                }
            }
        });
    }

    @Test
    public void testNoException() throws Exception {
        this.putMessageOnQueue("noException");
        Assert.assertFalse((String)"Message should not have been redelivered", (boolean)this.messageRedelivered.await(5000L, TimeUnit.MILLISECONDS));
    }

    @Test
    public void testTransformerException() throws Exception {
        this.putMessageOnQueue("transformerException");
        Assert.assertTrue((String)"Message was not redelivered", (boolean)this.messageRedelivered.await(5000L, TimeUnit.MILLISECONDS));
    }

    @Test
    public void testRouterException() throws Exception {
        this.putMessageOnQueue("routerException");
        Assert.assertTrue((String)"Message was not redelivered", (boolean)this.messageRedelivered.await(5000L, TimeUnit.MILLISECONDS));
    }

    @Test
    public void testComponentException() throws Exception {
        this.putMessageOnQueue("componentException");
        Assert.assertFalse((String)"Message should not have been redelivered", (boolean)this.messageRedelivered.await(5000L, TimeUnit.MILLISECONDS));
    }
}

