/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms;

import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.transport.jms.AbstractJmsRedeliveryTestCase;

public class JmsNoRedeliveryTestCase
extends AbstractJmsRedeliveryTestCase {
    public JmsNoRedeliveryTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Override
    protected int getMaxRedelivery() {
        return 0;
    }

    @Override
    protected int getMaxRedeliveryAttempts() {
        return 0;
    }

    @Test
    public void testNoRedelivery() throws Exception {
        this.client.dispatch("jms://in?connector=jmsConnectorLimitedRedelivery", (Object)"Test Message", null);
        Assert.assertTrue((boolean)this.messageRedeliveryExceptionFired.await((long)this.timeout, TimeUnit.MILLISECONDS));
        Assert.assertEquals((String)"MessageRedeliveredException never fired.", (long)0L, (long)this.messageRedeliveryExceptionFired.getCount());
        Assert.assertEquals((String)"Wrong number of delivery attempts", (long)1L, (long)this.callback.getCallbackCount());
        this.assertMessageInDlq();
    }

    @Test
    public void testRedeliveryWithRollbackExceptionStrategy() throws Exception {
        this.client.dispatch("jms://in2?connector=jmsConnectorNoRedelivery", (Object)"Test Message", null);
        Assert.assertTrue((boolean)this.messageRedeliveryExceptionFired.await((long)this.timeout, TimeUnit.MILLISECONDS));
        Assert.assertEquals((String)"MessageRedeliveredException never fired.", (long)0L, (long)this.messageRedeliveryExceptionFired.getCount());
        Assert.assertEquals((String)"Wrong number of delivery attempts", (long)1L, (long)this.callback.getCallbackCount());
        this.assertMessageInDlqRollbackEs();
    }
}

