/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms.integration;

import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleContext;
import org.mule.message.ExceptionMessage;
import org.mule.transport.jms.integration.AbstractJmsFunctionalTestCase;
import org.mule.util.SerializationUtils;

public class JmsDeadLetterQueueTestCase
extends AbstractJmsFunctionalTestCase {
    public static final String DEADLETTER_QUEUE_NAME = "dlq";
    AbstractJmsFunctionalTestCase.Scenario scenarioDeadLetter = new ScenarioDeadLetter();
    AbstractJmsFunctionalTestCase.Scenario scenarioDeadLetterRollback = new ScenarioDeadLetterRollback();
    AbstractJmsFunctionalTestCase.Scenario scenarioDeadLetterNotReceive = new ScenarioDeadLetterNotReceive();

    protected String getConfigResources() {
        return "integration/jms-dead-letter-queue.xml";
    }

    @Test
    public void testTransactedRedeliveryToDLDestination() throws Exception {
        this.send(this.scenarioDeadLetter);
        this.receive(this.scenarioNotReceive);
        this.receive(this.scenarioDeadLetter);
    }

    @Test
    public void testTransactedRedeliveryToDLDestinationRollback() throws Exception {
        this.send(this.scenarioDeadLetter);
        this.receive(this.scenarioDeadLetterRollback);
        this.receive(this.scenarioDeadLetter);
        this.receive(this.scenarioDeadLetterNotReceive);
    }

    class ScenarioDeadLetterNotReceive
    extends ScenarioDeadLetter {
        ScenarioDeadLetterNotReceive() {
        }

        @Override
        public Message receive(Session session, MessageConsumer consumer) throws JMSException {
            Message message = consumer.receive(JmsDeadLetterQueueTestCase.this.getSmallTimeout());
            Assert.assertNull((Object)message);
            return message;
        }
    }

    class ScenarioDeadLetterRollback
    extends ScenarioDeadLetter {
        ScenarioDeadLetterRollback() {
        }

        @Override
        protected void applyTransaction(Session session) throws JMSException {
            session.rollback();
        }
    }

    class ScenarioDeadLetter
    extends AbstractJmsFunctionalTestCase.ScenarioCommit {
        ScenarioDeadLetter() {
            super(JmsDeadLetterQueueTestCase.this);
        }

        @Override
        public String getOutputDestinationName() {
            return JmsDeadLetterQueueTestCase.DEADLETTER_QUEUE_NAME;
        }

        @Override
        public Message receive(Session session, MessageConsumer consumer) throws JMSException {
            Message message = consumer.receive(JmsDeadLetterQueueTestCase.this.getTimeout());
            Assert.assertNotNull((Object)message);
            Object obj = null;
            if (message instanceof BytesMessage) {
                byte[] messageBytes = new byte[(int)((BytesMessage)message).getBodyLength()];
                ((BytesMessage)message).readBytes(messageBytes);
                obj = SerializationUtils.deserialize((byte[])messageBytes, (MuleContext)muleContext);
            } else if (message instanceof ObjectMessage) {
                obj = ((ObjectMessage)message).getObject();
            } else {
                Assert.fail((String)("Message is an unexpected type: " + message.getClass().getName()));
            }
            Assert.assertTrue((boolean)(obj instanceof ExceptionMessage));
            Object payload = ((ExceptionMessage)obj).getPayload();
            if (payload instanceof TextMessage) {
                Assert.assertEquals((Object)"INPUT MESSAGE", (Object)((TextMessage)payload).getText());
            } else if (payload instanceof String) {
                Assert.assertEquals((Object)"INPUT MESSAGE", (Object)payload);
            } else {
                Assert.fail((String)("Payload is an unexpected type: " + payload.getClass().getName()));
            }
            String dest = message.getStringProperty("MULE_ENDPOINT");
            if (dest != null) {
                Assert.assertEquals((Object)"jms://dlq", (Object)dest);
            }
            this.applyTransaction(session);
            return message;
        }
    }
}

