/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms;

import java.util.Arrays;
import java.util.Collection;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.runners.Parameterized;
import org.mule.api.MuleEventContext;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.client.MuleClient;
import org.mule.api.context.notification.ExceptionNotificationListener;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.api.exception.MessageRedeliveredException;
import org.mule.context.notification.ExceptionNotification;
import org.mule.context.notification.NotificationException;
import org.mule.message.ExceptionMessage;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.exceptions.FunctionalTestException;
import org.mule.tck.functional.CounterCallback;
import org.mule.tck.functional.EventCallback;
import org.mule.tck.functional.FunctionalTestComponent;
import org.mule.util.concurrent.Latch;

public abstract class AbstractJmsRedeliveryTestCase
extends AbstractServiceAndFlowTestCase {
    protected static final String JMS_INPUT_QUEUE = "jms://in?connector=jmsConnectorLimitedRedelivery";
    protected static final String JMS_INPUT_QUEUE2 = "jms://in2?connector=jmsConnectorNoRedelivery";
    protected static final String JMS_DEAD_LETTER = "jms://dead.letter?connector=jmsConnectorNoRedelivery";
    protected final int timeout = this.getTestTimeoutSecs() * 1000 / 4;
    protected MuleClient client;
    protected Latch messageRedeliveryExceptionFired;
    protected CounterCallback callback;

    public AbstractJmsRedeliveryTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
        System.setProperty("maxRedelivery", String.valueOf(this.getMaxRedelivery()));
        System.setProperty("maxRedeliveryAttempts", String.valueOf(this.getMaxRedeliveryAttempts()));
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "jms-redelivery-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "jms-redelivery-flow.xml"});
    }

    @Before
    public void setUp() throws Exception {
        this.client = muleContext.getClient();
        this.messageRedeliveryExceptionFired = new Latch();
        this.registerEventListener(this.messageRedeliveryExceptionFired);
        this.purgeQueue();
        this.setupCallback();
    }

    protected void assertMessageInDlq() throws MuleException {
        MuleMessage dl = this.client.request(JMS_DEAD_LETTER, 1000L);
        Assert.assertNotNull((Object)dl);
        Assert.assertTrue((boolean)(dl.getPayload() instanceof ExceptionMessage));
        ExceptionMessage em = (ExceptionMessage)dl.getPayload();
        Assert.assertNotNull((Object)em.getException());
        Assert.assertTrue((boolean)(em.getException() instanceof MessageRedeliveredException));
    }

    protected void assertMessageInDlqRollbackEs() throws Exception {
        MuleMessage dl = this.client.request(JMS_DEAD_LETTER, 1000L);
        Assert.assertNotNull((Object)dl);
        Assert.assertTrue((boolean)dl.getPayloadAsString().equals("Test Message"));
    }

    protected void purgeQueue() throws MuleException {
        while (this.client.request(JMS_INPUT_QUEUE, 1000L) != null) {
            this.logger.warn((Object)"Destination jms://in?connector=jmsConnectorLimitedRedelivery isn't empty, draining it");
        }
    }

    protected void setupCallback() throws Exception {
        this.callback = this.createCallback();
        FunctionalTestComponent ftc = this.getFunctionalTestComponent("Bouncer");
        FunctionalTestComponent ftc2 = this.getFunctionalTestComponent("Bouncer2");
        ftc.setEventCallback((EventCallback)this.callback);
        ftc2.setEventCallback((EventCallback)this.callback);
    }

    private CounterCallback createCallback() {
        return new CounterCallback(){

            public void eventReceived(MuleEventContext context, Object Component) throws Exception {
                int count = this.incCallbackCount();
                AbstractJmsRedeliveryTestCase.this.logger.info((Object)("Message Delivery Count is: " + count));
                throw new FunctionalTestException();
            }
        };
    }

    private void registerEventListener(final Latch messageRedeliveryExceptionFired) throws NotificationException {
        muleContext.registerListener((ServerNotificationListener)new ExceptionNotificationListener<ExceptionNotification>(){

            public void onNotification(ExceptionNotification notification) {
                if (notification.getException() instanceof MessageRedeliveredException) {
                    messageRedeliveryExceptionFired.countDown();
                }
            }
        });
    }

    protected void assertNoMessageInDlq(String location) throws MuleException {
        Assert.assertNull((Object)this.client.request(location, 1000L));
    }

    @After
    public void cleanUpMaxRedelivery() {
        System.clearProperty("maxRedelivery");
        System.clearProperty("maxRedeliveryAttempts");
    }

    protected abstract int getMaxRedelivery();

    protected abstract int getMaxRedeliveryAttempts();
}

