/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms;

import javax.jms.ConnectionFactory;
import org.junit.Assert;
import org.junit.Test;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.transport.jms.JmsConnector;
import org.mule.transport.jms.test.TestConnectionFactory;

public class JmsConnectionFactoryTestCase
extends FunctionalTestCase {
    protected String getConfigResources() {
        return "jms-connection-factory.xml";
    }

    @Test
    public void testProviderPropertiesNotPassed() throws Exception {
        JmsConnector c = (JmsConnector)muleContext.getRegistry().lookupConnector("jmsConnector1");
        Assert.assertNotNull((Object)c);
        ConnectionFactory cf = c.getConnectionFactory();
        Assert.assertTrue((boolean)(cf instanceof TestConnectionFactory));
        Assert.assertEquals((String)"Provider properties should not be passed to the ConnectionFactory.", (Object)"NOT_SET", (Object)((TestConnectionFactory)cf).getProviderProperty());
    }

    @Test
    public void testConnectionFactoryPropertiesPassed() throws Exception {
        JmsConnector c = (JmsConnector)muleContext.getRegistry().lookupConnector("jmsConnector2");
        Assert.assertNotNull((Object)c);
        ConnectionFactory cf = c.getConnectionFactory();
        Assert.assertTrue((boolean)(cf instanceof TestConnectionFactory));
        Assert.assertEquals((String)"ConnectionFactory properties should be passed to the ConnectionFactory.", (Object)"TEST_VALUE", (Object)((TestConnectionFactory)cf).getConnectionFactoryProperty());
    }
}

