/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms;

import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.transport.jms.AbstractJmsRedeliveryTestCase;

public class JmsRedeliveryTestCase
extends AbstractJmsRedeliveryTestCase {
    private static final int MAX_REDELIVERY = 2;
    private static final int MAX_REDELIVERY_ATTEMPTS = 3;

    public JmsRedeliveryTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Override
    protected int getMaxRedelivery() {
        return 2;
    }

    @Override
    protected int getMaxRedeliveryAttempts() {
        return 3;
    }

    @Test
    public void testRedelivery() throws Exception {
        this.client.dispatch("jms://in?connector=jmsConnectorLimitedRedelivery", (Object)"Test Message", null);
        Assert.assertTrue((boolean)this.messageRedeliveryExceptionFired.await((long)this.timeout, TimeUnit.MILLISECONDS));
        Assert.assertEquals((String)"MessageRedeliveredException never fired.", (long)0L, (long)this.messageRedeliveryExceptionFired.getCount());
        Assert.assertEquals((String)"Wrong number of delivery attempts", (long)3L, (long)this.callback.getCallbackCount());
        this.assertMessageInDlq();
    }

    @Test
    public void testRedeliveryWithRollbackExceptionStrategy() throws Exception {
        this.client.dispatch("jms://in2?connector=jmsConnectorNoRedelivery", (Object)"Test Message", null);
        Assert.assertTrue((boolean)this.messageRedeliveryExceptionFired.await((long)this.timeout, TimeUnit.MILLISECONDS));
        Assert.assertEquals((String)"MessageRedeliveredException never fired.", (long)0L, (long)this.messageRedeliveryExceptionFired.getCount());
        Assert.assertEquals((String)"Wrong number of delivery attempts", (long)4L, (long)this.callback.getCallbackCount());
        this.assertMessageInDlqRollbackEs();
    }
}

