/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms;

import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.service.Service;
import org.mule.api.source.MessageSource;
import org.mule.construct.Flow;
import org.mule.service.ServiceCompositeMessageSource;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.transport.jms.JmsConnector;
import org.mule.transport.jms.filters.JmsSelectorFilter;

public class JmsSelectorDetectionTestCase
extends AbstractServiceAndFlowTestCase {
    public JmsSelectorDetectionTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
        this.setStartContext(false);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "jms-selector-detection-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "jms-selector-detection-flow.xml"});
    }

    @Test
    public void testDetectsSelector() throws Exception {
        MessageSource source = this.getSource();
        InboundEndpoint ep = null;
        ep = this.getEnpoint(source, ep);
        JmsConnector connector = (JmsConnector)muleContext.getRegistry().lookupConnector("jmsConnector");
        JmsSelectorFilter selector = connector.getSelector((ImmutableEndpoint)ep);
        Assert.assertNotNull((Object)selector);
    }

    private InboundEndpoint getEnpoint(MessageSource source, InboundEndpoint ep) {
        if (source instanceof InboundEndpoint) {
            ep = (InboundEndpoint)source;
        } else if (source instanceof ServiceCompositeMessageSource) {
            ep = (InboundEndpoint)((ServiceCompositeMessageSource)source).getEndpoints().get(0);
        }
        return ep;
    }

    private MessageSource getSource() {
        MessageSource source;
        Object flowOrService = muleContext.getRegistry().lookupObject("TestSelector");
        Assert.assertNotNull((Object)flowOrService);
        if (flowOrService instanceof Service) {
            Service svc = (Service)flowOrService;
            source = svc.getMessageSource();
        } else {
            Flow flow = (Flow)flowOrService;
            source = flow.getMessageSource();
        }
        return source;
    }
}

