/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms.integration;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.mule.transport.jms.integration.AbstractJmsFunctionalTestCase;

public class JmsXAAlwaysBeginTestCase
extends AbstractJmsFunctionalTestCase {
    private static final List committedTx = new CopyOnWriteArrayList();
    private static final List rolledbackTx = new CopyOnWriteArrayList();
    protected static final Log logger = LogFactory.getLog(JmsXAAlwaysBeginTestCase.class);

    protected String getConfigResources() {
        return "integration/jms-xa-tx-ALWAYS_BEGIN.xml";
    }

    @Override
    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.purge(this.getInboundQueueName());
        this.purge(this.getOutboundQueueName());
    }

    @Override
    protected void doTearDown() throws Exception {
        super.doTearDown();
        this.purge(this.getInboundQueueName());
        this.purge(this.getOutboundQueueName());
    }

    @Test
    public void testAlwaysBeginTx() throws Exception {
        this.send(this.scenarioNoTx);
        this.receive(this.scenarioNoTx);
        this.receive(this.scenarioNoTx);
        this.receive(this.scenarioNotReceive);
        Assert.assertEquals((long)committedTx.size(), (long)0L);
        Assert.assertEquals((long)rolledbackTx.size(), (long)2L);
    }

    @Ignore
    public static class TestResource
    implements XAResource {
        protected int _timeout = 0;

        @Override
        public void commit(Xid id, boolean onePhase) throws XAException {
            committedTx.add(id);
            logger.debug((Object)("XA_COMMIT[" + id + "]"));
        }

        @Override
        public void end(Xid xid, int flags) throws XAException {
            logger.debug((Object)("XA_END[" + xid + "] Flags=" + flags));
        }

        @Override
        public void forget(Xid xid) throws XAException {
            logger.debug((Object)("XA_FORGET[" + xid + "]"));
        }

        @Override
        public int getTransactionTimeout() throws XAException {
            return this._timeout;
        }

        @Override
        public boolean isSameRM(XAResource xares) throws XAException {
            return xares.equals(this);
        }

        @Override
        public int prepare(Xid xid) throws XAException {
            logger.debug((Object)("XA_PREPARE[" + xid + "]"));
            return 0;
        }

        @Override
        public Xid[] recover(int flag) throws XAException {
            logger.debug((Object)("RECOVER[" + flag + "]"));
            return null;
        }

        @Override
        public void rollback(Xid xid) throws XAException {
            rolledbackTx.add(xid);
            logger.debug((Object)("XA_ROLLBACK[" + xid + "]"));
        }

        @Override
        public boolean setTransactionTimeout(int seconds) throws XAException {
            this._timeout = seconds;
            return true;
        }

        @Override
        public void start(Xid xid, int flags) throws XAException {
            logger.debug((Object)("XA_START[" + xid + "] Flags=" + flags));
        }
    }

    @Ignore
    public static class TestRollbackComponent {
        public Object processObject(Object a) throws Exception {
            logger.debug((Object)("TestRollbackComponent " + a));
            TestResource res = new TestResource();
            Transaction currentTrans = muleContext.getTransactionManager().getTransaction();
            currentTrans.enlistResource((XAResource)res);
            currentTrans.setRollbackOnly();
            return "OUTPUT MESSAGE";
        }
    }
}

