/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms.jndi;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.api.MuleException;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.transport.jms.jndi.CachedJndiNameResolver;

public class CachedJndiNameResolverTestCase
extends AbstractMuleTestCase {
    private static final String RESOLVED_NAME = "resolvedName";
    private static final String NAME = "name";

    @Test
    public void testResolvesWithCache() throws NamingException, MuleException {
        Context context = (Context)Mockito.mock(Context.class);
        Mockito.when((Object)context.lookup(NAME)).thenReturn((Object)RESOLVED_NAME);
        InitialContextFactory jndiContextFactory = (InitialContextFactory)Mockito.mock(InitialContextFactory.class);
        Mockito.when((Object)jndiContextFactory.getInitialContext((Hashtable)Matchers.any(Hashtable.class))).thenReturn((Object)context);
        CachedJndiNameResolver jndiNameResolver = new CachedJndiNameResolver();
        jndiNameResolver.setContextFactory(jndiContextFactory);
        jndiNameResolver.setJndiInitialFactory("initialFactory");
        jndiNameResolver.initialise();
        Assert.assertEquals((Object)RESOLVED_NAME, (Object)jndiNameResolver.lookup(NAME));
        Assert.assertEquals((Object)RESOLVED_NAME, (Object)jndiNameResolver.lookup(NAME));
        ((Context)Mockito.verify((Object)context, (VerificationMode)Mockito.times((int)1))).lookup(NAME);
    }
}

