/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms;

import javax.jms.Destination;
import javax.jms.Queue;
import javax.jms.Topic;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.transport.jms.DefaultJmsTopicResolver;
import org.mule.transport.jms.JmsConnector;

public class DefaultJmsTopicResolverTestCase
extends FunctionalTestCase {
    private JmsConnector connector;
    private DefaultJmsTopicResolver resolver;

    protected String getConfigFile() {
        return "jms-topic-resolver.xml";
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.connector = (JmsConnector)muleContext.getRegistry().lookupConnector("jmsConnector");
        this.resolver = (DefaultJmsTopicResolver)this.connector.getTopicResolver();
    }

    @Test
    public void testSameConnector() {
        Assert.assertSame((Object)this.connector, (Object)this.resolver.getConnector());
    }

    @Test
    public void testEndpointNotTopicWithFallback() throws Exception {
        InboundEndpoint endpoint = muleContext.getEndpointFactory().getInboundEndpoint("ep1");
        Assert.assertFalse((boolean)this.resolver.isTopic((ImmutableEndpoint)endpoint));
    }

    @Test
    public void testEndpointNotTopicWithFallback2() throws Exception {
        InboundEndpoint endpoint = muleContext.getEndpointFactory().getInboundEndpoint("ep1");
        Assert.assertFalse((boolean)this.resolver.isTopic((ImmutableEndpoint)endpoint, true));
    }

    @Test
    public void testEndpointNotTopicNoFallback() throws Exception {
        InboundEndpoint endpoint = muleContext.getEndpointFactory().getInboundEndpoint("ep1");
        Assert.assertFalse((boolean)this.resolver.isTopic((ImmutableEndpoint)endpoint, false));
    }

    @Test
    public void testEndpointTopicPropertyWithFallback() throws Exception {
        InboundEndpoint endpoint = muleContext.getEndpointFactory().getInboundEndpoint("ep2");
        Assert.assertTrue((boolean)this.resolver.isTopic((ImmutableEndpoint)endpoint));
    }

    @Test
    public void testEndpointTopicPropertyWithFallback2() throws Exception {
        InboundEndpoint endpoint = muleContext.getEndpointFactory().getInboundEndpoint("ep2");
        Assert.assertTrue((boolean)this.resolver.isTopic((ImmutableEndpoint)endpoint, true));
    }

    @Test
    public void testEndpointTopicPropertyNoFallback() throws Exception {
        InboundEndpoint endpoint = muleContext.getEndpointFactory().getInboundEndpoint("ep2");
        Assert.assertFalse((boolean)this.resolver.isTopic((ImmutableEndpoint)endpoint, false));
    }

    @Test
    public void testEndpointTopicPrefixWithFallback() throws Exception {
        InboundEndpoint endpoint = muleContext.getEndpointFactory().getInboundEndpoint("ep3");
        Assert.assertTrue((boolean)this.resolver.isTopic((ImmutableEndpoint)endpoint));
    }

    @Test
    public void testEndpointTopicPrefixWithFallback2() throws Exception {
        InboundEndpoint endpoint = muleContext.getEndpointFactory().getInboundEndpoint("ep3");
        Assert.assertTrue((boolean)this.resolver.isTopic((ImmutableEndpoint)endpoint, true));
    }

    @Test
    public void testEndpointTopicPrefixNoFallback() throws Exception {
        InboundEndpoint endpoint = muleContext.getEndpointFactory().getInboundEndpoint("ep3");
        Assert.assertTrue((boolean)this.resolver.isTopic((ImmutableEndpoint)endpoint, false));
    }

    @Test
    public void testEndpointTopicPrefixAndPropertyWithFallback() throws Exception {
        InboundEndpoint endpoint = muleContext.getEndpointFactory().getInboundEndpoint("ep4");
        Assert.assertTrue((boolean)this.resolver.isTopic((ImmutableEndpoint)endpoint));
    }

    @Test
    public void testEndpointTopicPrefixAndPropertyWithFallback2() throws Exception {
        InboundEndpoint endpoint = muleContext.getEndpointFactory().getInboundEndpoint("ep4");
        Assert.assertTrue((boolean)this.resolver.isTopic((ImmutableEndpoint)endpoint, true));
    }

    @Test
    public void testEndpointTopicPrefixAndPropertyNoFallback() throws Exception {
        InboundEndpoint endpoint = muleContext.getEndpointFactory().getInboundEndpoint("ep4");
        Assert.assertTrue((boolean)this.resolver.isTopic((ImmutableEndpoint)endpoint, false));
    }

    @Test
    public void testEndpointTopicUsesEndpointProperties() throws Exception {
        InboundEndpoint endpoint = muleContext.getEndpointFactory().getInboundEndpoint("ep5");
        Assert.assertTrue((boolean)this.resolver.isTopic((ImmutableEndpoint)endpoint));
    }

    @Test
    public void testEndpointTopicWithLeadingSlash() throws Exception {
        InboundEndpoint endpoint = muleContext.getEndpointFactory().getInboundEndpoint("ep6");
        Assert.assertTrue((boolean)this.resolver.isTopic((ImmutableEndpoint)endpoint));
    }

    @Test
    public void testEndpointTopicWithSlashes() throws Exception {
        InboundEndpoint endpoint = muleContext.getEndpointFactory().getInboundEndpoint("ep7");
        Assert.assertTrue((boolean)this.resolver.isTopic((ImmutableEndpoint)endpoint));
    }

    @Test
    public void testEndpointQueueWithSlashes() throws Exception {
        InboundEndpoint endpoint = muleContext.getEndpointFactory().getInboundEndpoint("ep8");
        Assert.assertFalse((boolean)this.resolver.isTopic((ImmutableEndpoint)endpoint));
    }

    @Test
    public void testDestinationNotTopic() throws Exception {
        Queue queue = (Queue)Mockito.mock(Queue.class);
        Assert.assertFalse((boolean)this.resolver.isTopic((Destination)queue));
    }

    @Test
    public void testDestinationTopic() throws Exception {
        Topic topic = (Topic)Mockito.mock(Topic.class);
        Assert.assertTrue((boolean)this.resolver.isTopic((Destination)topic));
    }
}

