/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.Topic;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.transport.jms.Jms11Support;
import org.mule.transport.jms.JmsConnector;

public class Jms11SupportTestCase
extends AbstractMuleContextTestCase {
    @Test
    public void testNoLocalCalledForDurableTopic() throws Exception {
        Jms11Support jmsSupport = new Jms11Support(new JmsConnector(muleContext));
        Topic topic = (Topic)Mockito.mock(Topic.class);
        String durableName = "durableName";
        boolean noLocal = true;
        Session session = (Session)Mockito.mock(Session.class);
        jmsSupport.createConsumer(session, (Destination)topic, null, noLocal, durableName, true, (ImmutableEndpoint)Jms11SupportTestCase.getTestInboundEndpoint((String)"test"));
        ((Session)Mockito.verify((Object)session)).createDurableSubscriber((Topic)Matchers.eq((Object)topic), (String)Matchers.eq((Object)durableName), (String)Matchers.isNull(String.class), Matchers.eq((boolean)true));
    }

    @Test
    public void testNoLocalCalledForNonDurableTopic() throws Exception {
        Jms11Support jmsSupport = new Jms11Support(new JmsConnector(muleContext));
        Topic topic = (Topic)Mockito.mock(Topic.class);
        boolean noLocal = true;
        Session session = (Session)Mockito.mock(Session.class);
        jmsSupport.createConsumer(session, (Destination)topic, null, noLocal, null, true, (ImmutableEndpoint)Jms11SupportTestCase.getTestInboundEndpoint((String)"test"));
        ((Session)Mockito.verify((Object)session)).createConsumer((Destination)Matchers.eq((Object)topic), (String)Matchers.isNull(String.class), Matchers.eq((boolean)true));
    }

    @Test
    public void testNoLocalNotCalledForQueue() throws Exception {
        Jms11Support jmsSupport = new Jms11Support(new JmsConnector(muleContext));
        Queue queue = (Queue)Mockito.mock(Queue.class);
        boolean noLocal = true;
        Session session = (Session)Mockito.mock(Session.class);
        jmsSupport.createConsumer(session, (Destination)queue, null, noLocal, null, false, (ImmutableEndpoint)Jms11SupportTestCase.getTestInboundEndpoint((String)"test"));
        ((Session)Mockito.verify((Object)session)).createConsumer((Destination)Matchers.eq((Object)queue), (String)Matchers.isNull(String.class));
    }

    @Test
    public void testDurableWithQueueThrowsException() throws Exception {
        Jms11Support jmsSupport = new Jms11Support(new JmsConnector(muleContext));
        Queue queue = (Queue)Mockito.mock(Queue.class);
        String durableName = "durableName";
        boolean noLocal = true;
        Session session = (Session)Mockito.mock(Session.class);
        try {
            jmsSupport.createConsumer(session, (Destination)queue, null, noLocal, durableName, false, (ImmutableEndpoint)Jms11SupportTestCase.getTestInboundEndpoint((String)"test"));
        }
        catch (JMSException jmsex) {
            Assert.assertEquals((String)"Wrong exception text.", (Object)"A durable subscriber name was set but the destination was not a Topic", (Object)jmsex.getMessage());
        }
    }
}

