/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms;

import java.lang.reflect.UndeclaredThrowableException;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.jms.XAConnectionFactory;
import javax.transaction.TransactionManager;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.api.MuleException;
import org.mule.api.transaction.Transaction;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.transaction.TransactionCoordination;
import org.mule.transport.jms.JmsConnector;
import org.mule.transport.jms.JmsSupport;
import org.mule.transport.jms.xa.ConnectionFactoryWrapper;

public class JmsConnectorTestCase
extends AbstractMuleContextTestCase {
    private static final String CLIENT_ID1 = "client1";
    private static final String CLIENT_ID2 = "client2";

    @Test
    public void testSetClientIDInConnectorForFirstTime() throws Exception {
        Connection connection = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)connection.getClientID()).thenReturn(null);
        JmsSupport jmsSupport = (JmsSupport)Mockito.mock(JmsSupport.class);
        Mockito.when((Object)jmsSupport.createConnection((ConnectionFactory)Matchers.any())).thenReturn((Object)connection);
        JmsConnector connector = new JmsConnector(muleContext);
        connector.setClientId(CLIENT_ID1);
        connector.setJmsSupport(jmsSupport);
        ConnectionFactory mockConnectionFactory = (ConnectionFactory)Mockito.mock(ConnectionFactory.class);
        connector.setConnectionFactory(mockConnectionFactory);
        Connection createdConnection = connector.createConnection();
        Assert.assertEquals((Object)connection, (Object)createdConnection);
        ((Connection)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)1))).setClientID(Matchers.anyString());
        ((Connection)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)1))).setClientID(CLIENT_ID1);
    }

    @Test
    public void testSetClientIDInConnectorForSecondTime() throws Exception {
        Connection connection = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)connection.getClientID()).thenReturn((Object)CLIENT_ID1);
        JmsSupport jmsSupport = (JmsSupport)Mockito.mock(JmsSupport.class);
        Mockito.when((Object)jmsSupport.createConnection((ConnectionFactory)Matchers.any())).thenReturn((Object)connection);
        JmsConnector connector = new JmsConnector(muleContext);
        ConnectionFactory mockConnectionFactory = (ConnectionFactory)Mockito.mock(ConnectionFactory.class);
        connector.setConnectionFactory(mockConnectionFactory);
        connector.setClientId(CLIENT_ID2);
        connector.setJmsSupport(jmsSupport);
        Connection createdConnection = connector.createConnection();
        Assert.assertEquals((Object)connection, (Object)createdConnection);
        ((Connection)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)1))).setClientID(Matchers.anyString());
        ((Connection)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)1))).setClientID(CLIENT_ID2);
    }

    @Test
    public void testSetClientIDInConnectionForFirstTime() throws Exception {
        Connection connection = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)connection.getClientID()).thenReturn((Object)CLIENT_ID1);
        JmsSupport jmsSupport = (JmsSupport)Mockito.mock(JmsSupport.class);
        Mockito.when((Object)jmsSupport.createConnection((ConnectionFactory)Matchers.any())).thenReturn((Object)connection);
        JmsConnector connector = new JmsConnector(muleContext);
        connector.setClientId(CLIENT_ID1);
        connector.setJmsSupport(jmsSupport);
        ConnectionFactory mockConnectionFactory = (ConnectionFactory)Mockito.mock(ConnectionFactory.class);
        connector.setConnectionFactory(mockConnectionFactory);
        Connection createdConnection = connector.createConnection();
        Assert.assertEquals((Object)connection, (Object)createdConnection);
        ((Connection)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)0))).setClientID(Matchers.anyString());
    }

    @Test
    public void testClosesSessionIfThereIsNoActiveTransaction() throws Exception {
        JmsConnector connector = new JmsConnector(muleContext);
        Session session = (Session)Mockito.mock(Session.class);
        connector.closeSessionIfNoTransactionActive(session);
        ((Session)Mockito.verify((Object)session, (VerificationMode)Mockito.times((int)1))).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDoNotClosesSessionIfThereIsAnActiveTransaction() throws Exception {
        Transaction transaction = (Transaction)Mockito.mock(Transaction.class);
        TransactionCoordination.getInstance().bindTransaction(transaction);
        try {
            JmsConnector connector = new JmsConnector(muleContext);
            Session session = (Session)Mockito.mock(Session.class);
            connector.closeSessionIfNoTransactionActive(session);
            ((Session)Mockito.verify((Object)session, (VerificationMode)Mockito.never())).close();
        }
        finally {
            TransactionCoordination.getInstance().unbindTransaction(transaction);
        }
    }

    @Test
    public void ignoreJmsExceptionOnStop() throws Exception {
        Connection connection = (Connection)Mockito.mock(Connection.class);
        ((Connection)Mockito.doThrow((Throwable)new JMSException("connection unavailable")).when((Object)connection)).stop();
        JmsConnector connector = new JmsConnector(muleContext);
        JmsConnector spy = (JmsConnector)Mockito.spy((Object)connector);
        ((JmsConnector)Mockito.doReturn((Object)connection).when((Object)spy)).createConnection();
        spy.doConnect();
        spy.doStop();
        ((Connection)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)1))).stop();
    }

    @Test
    public void ignoreAmqExceptionOnStop() throws Exception {
        Connection connection = (Connection)Mockito.mock(Connection.class);
        ((Connection)Mockito.doThrow((Throwable)new UndeclaredThrowableException(new Exception("connection unavailable"))).when((Object)connection)).stop();
        JmsConnector connector = new JmsConnector(muleContext);
        JmsConnector spy = (JmsConnector)Mockito.spy((Object)connector);
        ((JmsConnector)Mockito.doReturn((Object)connection).when((Object)spy)).createConnection();
        spy.doConnect();
        spy.doStop();
        ((Connection)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)1))).stop();
    }

    @Test
    public void doNotChangeConnectionFactoryWhenNotUsingXAConnectionFactory() throws Exception {
        muleContext.setTransactionManager((TransactionManager)Mockito.mock(TransactionManager.class));
        ConnectionFactory mockConnectionFactory = (ConnectionFactory)Mockito.mock(ConnectionFactory.class);
        JmsConnector connector = this.createConnectionFactoryWhenGettingConnection(mockConnectionFactory);
        Assert.assertThat((Object)connector.getConnectionFactory(), (Matcher)Is.is((Object)mockConnectionFactory));
    }

    @Test
    public void doNotChangeConnectionFactoryWhenNotUsingTransactionManager() throws Exception {
        ConnectionFactory mockConnectionFactory = (ConnectionFactory)Mockito.mock(TestXAConnectionFactory.class);
        JmsConnector connector = this.createConnectionFactoryWhenGettingConnection(mockConnectionFactory);
        Assert.assertThat((Object)connector.getConnectionFactory(), (Matcher)Is.is((Object)mockConnectionFactory));
    }

    @Test
    public void createConnectionFactoryWrapperWhenUsingTransactionManager() throws Exception {
        muleContext.setTransactionManager((TransactionManager)Mockito.mock(TransactionManager.class));
        JmsConnector connector = this.createConnectionFactoryWhenGettingConnection((ConnectionFactory)Mockito.mock(TestXAConnectionFactory.class));
        Assert.assertThat((Object)connector.getConnectionFactory(), (Matcher)IsInstanceOf.instanceOf(ConnectionFactoryWrapper.class));
    }

    private JmsConnector createConnectionFactoryWhenGettingConnection(ConnectionFactory mockConnectionFactory) throws JMSException, MuleException {
        Connection connection = (Connection)Mockito.mock(Connection.class);
        JmsSupport jmsSupport = (JmsSupport)Mockito.mock(JmsSupport.class);
        Mockito.when((Object)jmsSupport.createConnection((ConnectionFactory)Matchers.any())).thenReturn((Object)connection);
        JmsConnector connector = new JmsConnector(muleContext);
        connector.setJmsSupport(jmsSupport);
        connector.setName("testConnector");
        connector.setConnectionFactory(mockConnectionFactory);
        connector.createConnection();
        return connector;
    }

    private static interface TestXAConnectionFactory
    extends ConnectionFactory,
    XAConnectionFactory {
    }
}

