/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms;

import org.junit.Assert;
import org.junit.Test;
import org.mule.endpoint.MuleEndpointURI;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class JmsEndpointTestCase
extends AbstractMuleContextTestCase {
    @Test
    public void testWithoutFullUrl() throws Exception {
        MuleEndpointURI url = new MuleEndpointURI("jms:/my.queue", muleContext);
        url.initialise();
        Assert.assertEquals((Object)"jms", (Object)url.getScheme());
        Assert.assertEquals((Object)"my.queue", (Object)url.getAddress());
        Assert.assertNull((Object)url.getEndpointName());
        Assert.assertEquals((Object)"jms:/my.queue", (Object)url.toString());
    }

    @Test
    public void testFullUrlWithSlashes() throws Exception {
        MuleEndpointURI url = new MuleEndpointURI("jms://my/queue", muleContext);
        url.initialise();
        Assert.assertEquals((Object)"jms", (Object)url.getScheme());
        Assert.assertEquals((Object)"my/queue", (Object)url.getAddress());
        Assert.assertNull((Object)url.getEndpointName());
        Assert.assertEquals((Object)"jms://my/queue", (Object)url.toString());
    }

    @Test
    public void testWithoutFullUrlAndEndpointName() throws Exception {
        MuleEndpointURI url = new MuleEndpointURI("jms:/my.queue?endpointName=jmsProvider", muleContext);
        url.initialise();
        Assert.assertEquals((Object)"jms", (Object)url.getScheme());
        Assert.assertEquals((Object)"my.queue", (Object)url.getAddress());
        Assert.assertNotNull((Object)url.getEndpointName());
        Assert.assertEquals((Object)"jmsProvider", (Object)url.getEndpointName());
        Assert.assertEquals((Object)"jms:/my.queue?endpointName=jmsProvider", (Object)url.toString());
    }

    @Test
    public void testJmsUrl() throws Exception {
        MuleEndpointURI url = new MuleEndpointURI("jms://queue1?endpointName=jmsProvider", muleContext);
        url.initialise();
        Assert.assertEquals((Object)"jms", (Object)url.getScheme());
        Assert.assertEquals((Object)"queue1", (Object)url.getAddress());
        Assert.assertEquals((Object)"jmsProvider", (Object)url.getEndpointName());
        Assert.assertEquals((Object)"jms://queue1?endpointName=jmsProvider", (Object)url.toString());
    }

    @Test
    public void testJmsTopic() throws Exception {
        MuleEndpointURI url = new MuleEndpointURI("jms://topic:topic1", muleContext);
        url.initialise();
        Assert.assertEquals((Object)"jms", (Object)url.getScheme());
        Assert.assertEquals((Object)"topic1", (Object)url.getAddress());
        Assert.assertEquals((Object)"topic", (Object)url.getResourceInfo());
        Assert.assertEquals(null, (Object)url.getEndpointName());
        Assert.assertEquals((Object)"jms://topic:topic1", (Object)url.toString());
    }

    @Test
    public void testJmsTopicWithProvider() throws Exception {
        MuleEndpointURI url = new MuleEndpointURI("jms://topic:topic1?endpointName=jmsProvider", muleContext);
        url.initialise();
        Assert.assertEquals((Object)"jms", (Object)url.getScheme());
        Assert.assertEquals((Object)"topic1", (Object)url.getAddress());
        Assert.assertEquals((Object)"jmsProvider", (Object)url.getEndpointName());
        Assert.assertEquals((Object)"topic", (Object)url.getResourceInfo());
        Assert.assertEquals((Object)"jms://topic:topic1?endpointName=jmsProvider", (Object)url.toString());
    }

    @Test
    public void testJmsTopicWithUserInfo() throws Exception {
        MuleEndpointURI url = new MuleEndpointURI("jms://user:password@topic:topic1", muleContext);
        url.initialise();
        Assert.assertEquals((Object)"jms", (Object)url.getScheme());
        Assert.assertEquals((Object)"topic1", (Object)url.getAddress());
        Assert.assertEquals((Object)"topic", (Object)url.getResourceInfo());
        Assert.assertEquals((Object)"user:password", (Object)url.getUserInfo());
        Assert.assertEquals((Object)"user", (Object)url.getUser());
        Assert.assertEquals((Object)"password", (Object)url.getPassword());
        Assert.assertEquals((Object)"jms://user:****@topic:topic1", (Object)url.toString());
    }

    @Test
    public void testJmsTopicWithUserInfoAndProvider() throws Exception {
        MuleEndpointURI url = new MuleEndpointURI("jms://user:password@topic:topic1?endpointName=jmsProvider", muleContext);
        url.initialise();
        Assert.assertEquals((Object)"jms", (Object)url.getScheme());
        Assert.assertEquals((Object)"topic1", (Object)url.getAddress());
        Assert.assertEquals((Object)"jmsProvider", (Object)url.getEndpointName());
        Assert.assertEquals((Object)"topic", (Object)url.getResourceInfo());
        Assert.assertEquals((Object)"user:password", (Object)url.getUserInfo());
        Assert.assertEquals((Object)"user", (Object)url.getUser());
        Assert.assertEquals((Object)"password", (Object)url.getPassword());
        Assert.assertEquals((Object)"jms://user:****@topic:topic1?endpointName=jmsProvider", (Object)url.toString());
    }

    @Test
    public void testJmsDestWithSlashesAndUserInfoUsingAddressParam() throws Exception {
        MuleEndpointURI url = new MuleEndpointURI("jms://user:password@?address=/myQueues/myQueue", muleContext);
        url.initialise();
        Assert.assertEquals((Object)"jms", (Object)url.getScheme());
        Assert.assertEquals((Object)"/myQueues/myQueue", (Object)url.getAddress());
        Assert.assertEquals((Object)"user:password", (Object)url.getUserInfo());
        Assert.assertEquals((Object)"user", (Object)url.getUser());
        Assert.assertEquals((Object)"password", (Object)url.getPassword());
        Assert.assertEquals((Object)"jms://user:****@?address=/myQueues/myQueue", (Object)url.toString());
    }

    @Test
    public void testJmsDestWithSlashesAndUserInfo() throws Exception {
        MuleEndpointURI url = new MuleEndpointURI("jms://user:password@myQueues/myQueue", muleContext);
        url.initialise();
        Assert.assertEquals((Object)"jms", (Object)url.getScheme());
        Assert.assertEquals((Object)"myQueues/myQueue", (Object)url.getAddress());
        Assert.assertEquals((Object)"user:password", (Object)url.getUserInfo());
        Assert.assertEquals((Object)"user", (Object)url.getUser());
        Assert.assertEquals((Object)"password", (Object)url.getPassword());
        Assert.assertEquals((Object)"jms://user:****@myQueues/myQueue", (Object)url.toString());
    }

    @Test
    public void testJmsTopicDestinationsWithAddressParam() throws Exception {
        MuleEndpointURI url = new MuleEndpointURI("jms:topic://?address=[[testgroup]]test.topic", muleContext);
        url.initialise();
        Assert.assertEquals((Object)"jms", (Object)url.getScheme());
        Assert.assertEquals((Object)"[[testgroup]]test.topic", (Object)url.getAddress());
        Assert.assertEquals((Object)"topic", (Object)url.getResourceInfo());
        Assert.assertEquals((Object)"jms://?address=[[testgroup]]test.topic", (Object)url.toString());
    }

    @Test
    public void testJmsQueueDestinationsWithAddressParam() throws Exception {
        MuleEndpointURI url = new MuleEndpointURI("jms://?address=[[testgroup]]test.queue", muleContext);
        url.initialise();
        Assert.assertEquals((Object)"jms", (Object)url.getScheme());
        Assert.assertEquals((Object)"[[testgroup]]test.queue", (Object)url.getAddress());
        Assert.assertNull((Object)url.getResourceInfo());
        Assert.assertEquals((Object)"jms://?address=[[testgroup]]test.queue", (Object)url.toString());
    }

    @Test
    public void testJmsQueueDestinationsWithEncoding() throws Exception {
        MuleEndpointURI url = new MuleEndpointURI("jms://%5B%5Btestgroup%5D%5Dtest.queue", muleContext);
        url.initialise();
        Assert.assertEquals((Object)"jms", (Object)url.getScheme());
        Assert.assertEquals((Object)"[[testgroup]]test.queue", (Object)url.getAddress());
        Assert.assertNull((Object)url.getResourceInfo());
        Assert.assertEquals((Object)"jms://%5B%5Btestgroup%5D%5Dtest.queue", (Object)url.toString());
    }

    @Test
    public void testJmsTopicDestinationsWithEncoding() throws Exception {
        MuleEndpointURI url = new MuleEndpointURI("jms:topic://%5B%5Btestgroup%5D%5Dtest.topic", muleContext);
        url.initialise();
        Assert.assertEquals((Object)"jms", (Object)url.getScheme());
        Assert.assertEquals((Object)"[[testgroup]]test.topic", (Object)url.getAddress());
        Assert.assertEquals((Object)"topic", (Object)url.getResourceInfo());
        Assert.assertEquals((Object)"jms://%5B%5Btestgroup%5D%5Dtest.topic", (Object)url.toString());
    }

    @Test
    public void testJmsLegacyTopicDestinationsWithEncoding() throws Exception {
        MuleEndpointURI url = new MuleEndpointURI("jms://topic:%5B%5Btestgroup%5D%5Dtest.topic", muleContext);
        url.initialise();
        Assert.assertEquals((Object)"jms", (Object)url.getScheme());
        Assert.assertEquals((Object)"[[testgroup]]test.topic", (Object)url.getAddress());
        Assert.assertEquals((Object)"topic", (Object)url.getResourceInfo());
        Assert.assertEquals((Object)"jms://topic:%5B%5Btestgroup%5D%5Dtest.topic", (Object)url.toString());
    }
}

