/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms;

import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.transport.jms.AbstractJmsRedeliveryTestCase;

public class JmsInfiniteRedeliveryTestCase
extends AbstractJmsRedeliveryTestCase {
    public static final int DEFAULT_REDELIVERY = 6;

    public JmsInfiniteRedeliveryTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Override
    protected int getMaxRedelivery() {
        return -1;
    }

    @Override
    protected int getMaxRedeliveryAttempts() {
        return Integer.MAX_VALUE;
    }

    @Test
    public void testInfiniteRedelivery() throws Exception {
        this.client.dispatch("jms://in?connector=jmsConnectorLimitedRedelivery", (Object)"Test Message", null);
        Assert.assertFalse((boolean)this.messageRedeliveryExceptionFired.await((long)this.timeout, TimeUnit.MILLISECONDS));
        Assert.assertTrue((this.callback.getCallbackCount() > 7 ? 1 : 0) != 0);
        this.assertNoMessageInDlq("jms://dead.letter?connector=jmsConnectorNoRedelivery");
    }

    @Test
    public void testRedeliveryWithRollbackExceptionStrategy() throws Exception {
        this.client.dispatch("jms://in2?connector=jmsConnectorNoRedelivery", (Object)"Test Message", null);
        Assert.assertFalse((boolean)this.messageRedeliveryExceptionFired.await((long)this.timeout, TimeUnit.MILLISECONDS));
        Assert.assertTrue((this.callback.getCallbackCount() > 7 ? 1 : 0) != 0);
        this.assertNoMessageInDlq("jms://dead.letter?connector=jmsConnectorNoRedelivery");
    }
}

