/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.transport.jms.JmsConnector;
import org.mule.transport.jms.test.JmsTestContextFactory;

public class JmsJndiReconnectionTestCase
extends FunctionalTestCase {
    protected String getConfigFile() {
        return "jms-jndi-reconnection-config.xml";
    }

    @BeforeClass
    public static void makeInitialContextFail() {
        JmsTestContextFactory.failWhenRetrievingInitialContext = true;
    }

    @AfterClass
    public static void restoreInitialContextState() {
        JmsTestContextFactory.failWhenRetrievingInitialContext = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReconnectionWorksWhenInitialContextIsNotAvailable() throws Exception {
        JmsTestContextFactory.failWhenRetrievingInitialContext = true;
        try {
            final JmsConnector jmsConnector = (JmsConnector)muleContext.getRegistry().lookupConnector("jmsConnector");
            Assert.assertThat((Object)jmsConnector.isConnected(), (Matcher)Is.is((Object)false));
            JmsTestContextFactory.failWhenRetrievingInitialContext = false;
            PollingProber prober = new PollingProber(5000L, 100L);
            prober.check(new Probe(){

                public boolean isSatisfied() {
                    return jmsConnector.isConnected();
                }

                public String describeFailure() {
                    return "jms connector should be connected by now.";
                }
            });
        }
        finally {
            JmsTestContextFactory.failWhenRetrievingInitialContext = false;
        }
    }
}

