/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms;

import java.util.Iterator;
import javax.jms.TextMessage;
import org.apache.commons.collections.IteratorUtils;
import org.junit.Assert;
import org.mockito.Mockito;
import org.mule.api.MuleMessage;
import org.mule.api.transport.MuleMessageFactory;
import org.mule.transport.AbstractMuleMessageFactoryTestCase;
import org.mule.transport.jms.JmsMuleMessageFactory;

public class JmsMuleMessageFactoryTestCase
extends AbstractMuleMessageFactoryTestCase {
    private static final String MESSAGE_TEXT = "Test JMS Message";

    protected MuleMessageFactory doCreateMuleMessageFactory() {
        return new JmsMuleMessageFactory();
    }

    protected Object getValidTransportMessage() throws Exception {
        TextMessage textMessage = (TextMessage)Mockito.mock(TextMessage.class);
        Mockito.when((Object)textMessage.getText()).thenReturn((Object)MESSAGE_TEXT);
        Mockito.when((Object)textMessage.getJMSCorrelationID()).thenReturn(null);
        Mockito.when((Object)textMessage.getJMSDeliveryMode()).thenReturn((Object)1);
        Mockito.when((Object)textMessage.getJMSDestination()).thenReturn(null);
        Mockito.when((Object)textMessage.getJMSExpiration()).thenReturn((Object)0L);
        Mockito.when((Object)textMessage.getJMSMessageID()).thenReturn((Object)"1234567890");
        Mockito.when((Object)textMessage.getJMSPriority()).thenReturn((Object)4);
        Mockito.when((Object)textMessage.getJMSRedelivered()).thenReturn((Object)Boolean.FALSE);
        Mockito.when((Object)textMessage.getJMSReplyTo()).thenReturn(null);
        Mockito.when((Object)textMessage.getJMSTimestamp()).thenReturn((Object)0L);
        Mockito.when((Object)textMessage.getJMSType()).thenReturn(null);
        Mockito.when((Object)textMessage.getPropertyNames()).thenReturn((Object)IteratorUtils.asEnumeration((Iterator)IteratorUtils.arrayIterator((Object[])new Object[]{"foo"})));
        Mockito.when((Object)textMessage.getObjectProperty("foo")).thenReturn((Object)"bar");
        return textMessage;
    }

    protected Object getUnsupportedTransportMessage() {
        return "this is an invalid transport message for JmsMuleMessageFactory";
    }

    public void testValidPayload() throws Exception {
        MuleMessageFactory factory = this.createMuleMessageFactory();
        Object payload = this.getValidTransportMessage();
        MuleMessage message = factory.create(payload, this.encoding, muleContext);
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((Object)payload, (Object)message.getPayload());
        Assert.assertEquals((Object)"bar", (Object)message.getInboundProperty("foo"));
    }
}

