/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms;

import javax.jms.Message;
import javax.jms.TextMessage;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.RequestContext;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.transport.jms.transformers.ObjectToJMSMessage;

public class JmsTransformerTestCase
extends AbstractMuleContextTestCase {
    @Test
    public void testCustomJMSProperty() throws Exception {
        TextMessage textMessage = (TextMessage)Mockito.mock(TextMessage.class);
        Mockito.when((Object)textMessage.getJMSCorrelationID()).thenReturn(null);
        Mockito.when((Object)textMessage.getJMSMessageID()).thenReturn((Object)"1234567890");
        Mockito.when((Object)textMessage.getJMSDeliveryMode()).thenReturn((Object)1);
        Mockito.when((Object)textMessage.getJMSDestination()).thenReturn(null);
        Mockito.when((Object)textMessage.getJMSPriority()).thenReturn((Object)4);
        Mockito.when((Object)textMessage.getJMSRedelivered()).thenReturn((Object)Boolean.FALSE);
        Mockito.when((Object)textMessage.getJMSReplyTo()).thenReturn(null);
        Mockito.when((Object)textMessage.getJMSExpiration()).thenReturn((Object)0L);
        Mockito.when((Object)textMessage.getJMSTimestamp()).thenReturn((Object)0L);
        Mockito.when((Object)textMessage.getJMSType()).thenReturn(null);
        Mockito.when((Object)textMessage.getObjectProperty("JMS_CUSTOM_PROPERTY")).thenReturn((Object)"customValue");
        DefaultMuleMessage msg = new DefaultMuleMessage((Object)textMessage, muleContext);
        msg.setOutboundProperty("JMS_CUSTOM_PROPERTY", (Object)"customValue");
        Assert.assertNotNull((String)"The test hasn't been configured properly, no muleContext available", (Object)muleContext);
        RequestContext.setEvent((MuleEvent)new DefaultMuleEvent((MuleMessage)msg, MuleTestUtils.getTestEvent((Object)"previous", (MuleContext)muleContext)));
        ObjectToJMSMessage transformer = (ObjectToJMSMessage)this.createObject(ObjectToJMSMessage.class);
        Message transformed = (Message)transformer.transform(msg.getPayload());
        Assert.assertEquals((Object)"customValue", (Object)transformed.getObjectProperty("JMS_CUSTOM_PROPERTY"));
    }
}

