/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.transport.Connector;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.transport.jms.JmsConnector;
import org.mule.transport.jms.XaTransactedJmsMessageReceiver;

@RunWith(value=MockitoJUnitRunner.class)
public class XaTransactedJmsMessageReceiverTest
extends AbstractMuleTestCase {
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private JmsConnector mockJmsConnector;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private FlowConstruct mockFlowConstruct;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private InboundEndpoint mockInboundEndpoint;

    @Test
    public void testTopicReceiverShouldBeStartedOnlyInPrimaryNode() throws Exception {
        Mockito.when((Object)this.mockJmsConnector.getTopicResolver().isTopic((ImmutableEndpoint)this.mockInboundEndpoint)).thenReturn((Object)true);
        Mockito.when((Object)this.mockInboundEndpoint.getConnector()).thenReturn((Object)this.mockJmsConnector);
        XaTransactedJmsMessageReceiver messageReceiver = new XaTransactedJmsMessageReceiver((Connector)this.mockJmsConnector, this.mockFlowConstruct, this.mockInboundEndpoint);
        Assert.assertThat((String)"receiver must be started only in primary node", (Object)messageReceiver.shouldConsumeInEveryNode(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void testQueueReceiverShouldBeStartedInEveryNode() throws Exception {
        Mockito.when((Object)this.mockJmsConnector.getTopicResolver().isTopic((ImmutableEndpoint)this.mockInboundEndpoint)).thenReturn((Object)false);
        Mockito.when((Object)this.mockInboundEndpoint.getConnector()).thenReturn((Object)this.mockJmsConnector);
        XaTransactedJmsMessageReceiver messageReceiver = new XaTransactedJmsMessageReceiver((Connector)this.mockJmsConnector, this.mockFlowConstruct, this.mockInboundEndpoint);
        Assert.assertThat((String)"receiver must be started only in primary node", (Object)messageReceiver.shouldConsumeInEveryNode(), (Matcher)Is.is((Object)true));
    }
}

