/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms.config;

import javax.jms.ConnectionFactory;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.transport.jms.CustomCachingConnectionFactory;
import org.mule.transport.jms.config.CachingConnectionFactoryFactoryBean;

@SmallTest
public class CachingConnectionFactoryBeanTestCase
extends AbstractMuleTestCase {
    private final ConnectionFactory connectionFactoryDelegate = (ConnectionFactory)Mockito.mock(ConnectionFactory.class);
    private final CachingConnectionFactoryFactoryBean factoryBean = new CachingConnectionFactoryFactoryBean();

    @Test
    public void buildsDefaultCachingConnectionFactory() throws Exception {
        this.factoryBean.setConnectionFactory(this.connectionFactoryDelegate);
        CustomCachingConnectionFactory connectionFactory = this.factoryBean.createInstance();
        Assert.assertThat((Object)connectionFactory.getSessionCacheSize(), (Matcher)IsEqual.equalTo((Object)1));
        Assert.assertThat((Object)connectionFactory.isCacheProducers(), (Matcher)IsEqual.equalTo((Object)false));
        Assert.assertThat((Object)connectionFactory.isCacheConsumers(), (Matcher)IsEqual.equalTo((Object)false));
        Assert.assertThat((Object)connectionFactory.getUsername(), (Matcher)IsEqual.equalTo(null));
        Assert.assertThat((Object)connectionFactory.getPassword(), (Matcher)IsEqual.equalTo(null));
    }

    @Test
    public void usesCustomCacheSize() throws Exception {
        int customSize = 6;
        this.factoryBean.setConnectionFactory(this.connectionFactoryDelegate);
        this.factoryBean.setSessionCacheSize(customSize);
        CustomCachingConnectionFactory connectionFactory = this.factoryBean.createInstance();
        Assert.assertThat((Object)connectionFactory.getSessionCacheSize(), (Matcher)IsEqual.equalTo((Object)customSize));
    }

    @Test
    public void usesCustomCacheProducers() throws Exception {
        boolean customCacheProducers = true;
        this.factoryBean.setConnectionFactory(this.connectionFactoryDelegate);
        this.factoryBean.setCacheProducers(true);
        CustomCachingConnectionFactory connectionFactory = this.factoryBean.createInstance();
        Assert.assertThat((Object)connectionFactory.isCacheProducers(), (Matcher)IsEqual.equalTo((Object)true));
    }

    @Test
    public void usesCustomUser() throws Exception {
        String username = "user";
        String password = "password";
        this.factoryBean.setConnectionFactory(this.connectionFactoryDelegate);
        this.factoryBean.setUsername("user");
        this.factoryBean.setPassword("password");
        CustomCachingConnectionFactory connectionFactory = this.factoryBean.createInstance();
        Assert.assertThat((Object)connectionFactory.getUsername(), (Matcher)IsEqual.equalTo((Object)"user"));
        Assert.assertThat((Object)connectionFactory.getPassword(), (Matcher)IsEqual.equalTo((Object)"password"));
    }
}

