/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms.integration;

import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.mule.api.MuleMessage;
import org.mule.api.client.MuleClient;
import org.mule.api.config.ConfigurationBuilder;
import org.mule.api.transaction.Transaction;
import org.mule.config.spring.SpringXmlConfigurationBuilder;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.transaction.TransactionCoordination;
import org.mule.transport.jms.integration.JmsVendorConfiguration;
import org.mule.util.ClassUtils;
import org.mule.util.CollectionUtils;
import org.mule.util.IOUtils;
import org.mule.util.StringUtils;

public abstract class AbstractJmsFunctionalTestCase
extends FunctionalTestCase {
    public static final String DEFAULT_INPUT_MESSAGE = "INPUT MESSAGE";
    public static final String DEFAULT_OUTPUT_MESSAGE = "OUTPUT MESSAGE";
    public static final String INBOUND_ENDPOINT_KEY = "inbound.destination";
    public static final String OUTBOUND_ENDPOINT_KEY = "outbound.destination";
    public static final String MIDDLE_ENDPOINT_KEY = "middle.destination";
    public static final String MIDDLE2_ENDPOINT_KEY = "middle2.destination";
    public static final String MIDDLE3_ENDPOINT_KEY = "middle3.destination";
    public static final String BROADCAST_TOPIC_ENDPOINT_KEY = "broadcast.topic.destination";
    protected static final Log log = LogFactory.getLog((String)"MULE_TESTS");
    protected JmsVendorConfiguration jmsConfig = null;
    protected Scenario scenarioNoTx;
    protected Scenario scenarioCommit;
    protected Scenario scenarioRollback;
    protected Scenario scenarioNotReceive;
    protected Scenario scenarioReceive;
    protected boolean purgeQueuesOnPreSetUp = true;
    protected boolean purgeQueuesOnTearDown = true;
    private MuleClient client = null;
    private boolean multipleProviders = true;

    public static Collection<?> jmsProviderConfigs() {
        URL url = ClassUtils.getResource((String)"jms-vendor-configs.txt", AbstractJmsFunctionalTestCase.class);
        if (url == null) {
            Assert.fail((String)"Please specify the org.mule.transport.jms.integration.JmsVendorConfiguration implementation to use in jms-vendor-configs.txt on classpaath.");
            return CollectionUtils.EMPTY_COLLECTION;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Parameterized test using: " + url));
        }
        try {
            List classes = IOUtils.readLines((InputStream)url.openStream());
            JmsVendorConfiguration[][] configs = new JmsVendorConfiguration[1][classes.size()];
            int i = 0;
            for (String cls : classes) {
                configs[0][i] = (JmsVendorConfiguration)ClassUtils.instanciateClass((String)cls, (Object[])ClassUtils.NO_ARGS);
                ++i;
            }
            return Arrays.asList(configs);
        }
        catch (Exception e) {
            Assert.fail((String)("Please specify the org.mule.transport.jms.integration.JmsVendorConfiguration implementation to use in jms-vendor-configs.txt on classpath: " + e.getMessage()));
            return CollectionUtils.EMPTY_COLLECTION;
        }
    }

    public AbstractJmsFunctionalTestCase() {
        this(((JmsVendorConfiguration[])AbstractJmsFunctionalTestCase.jmsProviderConfigs().iterator().next())[0]);
    }

    public AbstractJmsFunctionalTestCase(JmsVendorConfiguration config) {
        this.setJmsConfig(config);
        this.scenarioNoTx = new NonTransactedScenario();
        this.scenarioCommit = new ScenarioCommit();
        this.scenarioRollback = new ScenarioRollback();
        this.scenarioNotReceive = new ScenarioNotReceive();
        this.scenarioReceive = new ScenarioReceive();
    }

    protected Properties getStartUpProperties() {
        Properties props = new Properties();
        props.put(INBOUND_ENDPOINT_KEY, this.getJmsConfig().getInboundEndpoint());
        props.put(OUTBOUND_ENDPOINT_KEY, this.getJmsConfig().getOutboundEndpoint());
        props.put(MIDDLE_ENDPOINT_KEY, this.getJmsConfig().getMiddleEndpoint());
        props.put(MIDDLE2_ENDPOINT_KEY, this.getJmsConfig().getMiddleEndpoint() + "2");
        props.put(MIDDLE3_ENDPOINT_KEY, this.getJmsConfig().getMiddleEndpoint() + "3");
        props.put(BROADCAST_TOPIC_ENDPOINT_KEY, this.getJmsConfig().getTopicBroadcastEndpoint());
        props.put("protocol", this.getJmsConfig().getProtocol());
        Map p = this.getJmsConfig().getProperties();
        if (p != null) {
            props.putAll((Map<?, ?>)p);
        }
        return props;
    }

    protected ConfigurationBuilder getBuilder() throws Exception {
        if (this.multipleProviders) {
            String configFile = this.getConfigFile();
            if (StringUtils.splitAndTrim((String)configFile, (String)",; ").length > 1) {
                throw new IllegalArgumentException("Parameterized tests don't support multiple config files as input: " + configFile);
            }
            String resources = configFile.substring(configFile.lastIndexOf("/") + 1);
            resources = String.format("integration/%s/connector-%s", this.getJmsConfig().getName(), resources);
            String[] configFiles = new String[]{resources, configFile};
            SpringXmlConfigurationBuilder builder = new SpringXmlConfigurationBuilder(configFiles);
            return builder;
        }
        return super.getBuilder();
    }

    public final JmsVendorConfiguration getJmsConfig() {
        if (this.jmsConfig == null) {
            this.jmsConfig = this.createJmsConfig();
        }
        return this.jmsConfig;
    }

    public final void setJmsConfig(JmsVendorConfiguration jmsConfig) {
        this.jmsConfig = jmsConfig;
    }

    protected JmsVendorConfiguration createJmsConfig() {
        return null;
    }

    protected final Connection getConnection(boolean topic, boolean xa) throws Exception {
        this.checkConfig();
        return this.getJmsConfig().getConnection(topic, xa);
    }

    protected final String getInboundEndpoint() {
        this.checkConfig();
        return this.getJmsConfig().getInboundEndpoint();
    }

    protected final String getOutboundEndpoint() {
        this.checkConfig();
        return this.getJmsConfig().getOutboundEndpoint();
    }

    protected final String getInboundQueueName() {
        this.checkConfig();
        return this.getJmsConfig().getInboundDestinationName();
    }

    protected final String getDeadLetterQueueName() {
        this.checkConfig();
        return this.getJmsConfig().getDeadLetterDestinationName();
    }

    protected final String getOutboundQueueName() {
        this.checkConfig();
        return this.getJmsConfig().getOutboundDestinationName();
    }

    protected final long getSmallTimeout() {
        this.checkConfig();
        return this.getJmsConfig().getSmallTimeout();
    }

    protected final long getTimeout() {
        this.checkConfig();
        return this.getJmsConfig().getTimeout();
    }

    protected void checkConfig() {
        if (this.getJmsConfig() == null) {
            throw new IllegalStateException("There must be a Jms Vendor config set on this test");
        }
    }

    protected void dispatchMessage() throws Exception {
        this.dispatchMessage(DEFAULT_INPUT_MESSAGE);
    }

    protected void dispatchMessage(Object payload) throws Exception {
        this.dispatchMessage(payload, null);
    }

    protected void dispatchMessage(Object payload, Map<String, Object> props) throws Exception {
        this.client.dispatch(this.getInboundEndpoint(), payload, props);
    }

    protected MuleMessage receiveMessage() throws Exception {
        return this.receiveMessage(DEFAULT_OUTPUT_MESSAGE);
    }

    protected MuleMessage receiveMessage(Object expected) throws Exception {
        MuleMessage result = this.client.request(this.getOutboundEndpoint(), this.getTimeout());
        Assert.assertNotNull((Object)result);
        Assert.assertNotNull((Object)result.getPayload());
        Assert.assertNull((Object)result.getExceptionPayload());
        Assert.assertEquals((Object)expected, (Object)result.getPayload());
        return result;
    }

    protected MuleMessage receiveMessage(byte[] expected) throws Exception {
        MuleMessage result = this.client.request(this.getOutboundEndpoint(), this.getTimeout());
        Assert.assertNotNull((Object)result);
        Assert.assertNotNull((Object)result.getPayload());
        Assert.assertNull((Object)result.getExceptionPayload());
        byte[] bytes = result.getPayloadAsBytes();
        Assert.assertEquals((String)"Wrong number of bytes", (long)expected.length, (long)bytes.length);
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((String)("Byte #" + i + " does not match"), (long)expected[i], (long)bytes[i]);
        }
        return result;
    }

    public void runAsynchronousDispatching() throws Exception {
        this.dispatchMessage();
        this.receiveMessage();
        MuleMessage result = this.client.request(this.getOutboundEndpoint(), this.getSmallTimeout());
        Assert.assertNull((Object)result);
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        if (this.purgeQueuesOnPreSetUp) {
            this.purge(this.getInboundQueueName());
            this.purge(this.getOutboundQueueName());
        }
        this.client = muleContext.getClient();
        Transaction tx = TransactionCoordination.getInstance().getTransaction();
        if (tx != null) {
            TransactionCoordination.getInstance().unbindTransaction(tx);
            log.warn((Object)"Transaction was active when this test began");
        }
    }

    protected void doTearDown() throws Exception {
        if (this.purgeQueuesOnTearDown) {
            this.purge(this.getInboundQueueName());
            this.purge(this.getOutboundQueueName());
            this.purgeTopics();
        }
        super.doTearDown();
        Transaction tx = TransactionCoordination.getInstance().getTransaction();
        if (tx != null) {
            TransactionCoordination.getInstance().unbindTransaction(tx);
            log.warn((Object)"Transaction was active when this test ended");
        }
    }

    protected MuleClient getClient() {
        return this.client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Scenario scenario) throws Exception {
        Connection connection = null;
        try {
            connection = this.getConnection(false, false);
            connection.start();
            Session session = null;
            try {
                session = connection.createSession(scenario.isTransacted(), scenario.getAcknowledge());
                Destination destination = this.createInputDestination(session, scenario);
                MessageProducer producer = null;
                try {
                    producer = session.createProducer(destination);
                    if (scenario.isPersistent()) {
                        producer.setDeliveryMode(2);
                    }
                    scenario.send(session, producer);
                }
                finally {
                    if (producer != null) {
                        producer.close();
                    }
                }
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    protected Destination createInputDestination(Session session, Scenario scenario) throws JMSException {
        return session.createQueue(scenario.getInputDestinationName());
    }

    protected Destination createOutputDestination(Session session, Scenario scenario) throws JMSException {
        return session.createQueue(scenario.getOutputDestinationName());
    }

    /*
     * Exception decompiling
     */
    public Message receive(Scenario scenario) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void purge(String destination) throws JMSException {
        Connection c = null;
        Session s = null;
        try {
            log.debug((Object)("purging queue : " + destination));
            c = this.getConnection(false, false);
            Assert.assertNotNull((Object)c);
            c.start();
            s = c.createSession(false, 1);
            Queue d = s.createQueue(destination);
            MessageConsumer consumer = s.createConsumer((Destination)d);
            while (consumer.receiveNoWait() != null) {
                log.debug((Object)("Destination " + destination + " isn't empty, draining it"));
            }
        }
        catch (Exception e) {
            log.error((Object)("unable to purge : " + destination));
        }
        finally {
            if (c != null) {
                c.stop();
                if (s != null) {
                    s.close();
                }
                try {
                    c.close();
                }
                catch (JMSException e) {
                    log.warn((Object)("Failed to close jms connection: " + e.getMessage()));
                }
            }
        }
    }

    protected void purgeTopics() throws Exception {
        String destination = "broadcast";
        this.purgeTopic(destination, "Client1");
        this.purgeTopic(destination, "Client2");
        this.purgeTopic(destination, "mule.JmsConnectorC1.broadcast");
        this.purgeTopic(destination, "mule.JmsConnectorC2.broadcast");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void purgeTopic(String destination, String topic) throws Exception {
        Connection c = null;
        TopicSession s = null;
        try {
            log.debug((Object)("purging topic : " + topic));
            c = this.getConnection(true, false);
            if (c == null) {
                log.debug((Object)("could not create a connection to topic : " + destination));
            }
            c.start();
            s = ((TopicConnection)c).createTopicSession(true, 0);
            log.debug((Object)"created topic session");
            Topic dest = s.createTopic(destination);
            log.debug((Object)"created topic destination");
            TopicSubscriber consumer = null;
            try {
                consumer = s.createDurableSubscriber(dest, topic);
                log.debug((Object)"created consumer");
                while (consumer.receiveNoWait() != null) {
                    log.debug((Object)("Topic " + topic + " isn't empty, draining it"));
                }
                log.debug((Object)"topic should be empty");
                consumer.close();
                s.unsubscribe(topic);
            }
            catch (JMSException e) {
                log.debug((Object)("could not unsubscribe : " + topic));
            }
        }
        finally {
            if (c != null) {
                c.stop();
                if (s != null) {
                    s.close();
                }
                try {
                    c.close();
                }
                catch (JMSException e) {
                    log.warn((Object)("Failed to close jms connection: " + e.getMessage()));
                }
            }
        }
        log.debug((Object)("completed draining topic :" + topic));
    }

    public boolean isMultipleProviders() {
        return this.multipleProviders;
    }

    public void setMultipleProviders(boolean multipleProviders) {
        this.multipleProviders = multipleProviders;
    }

    protected class ScenarioReceive
    extends NonTransactedScenario {
        protected ScenarioReceive() {
        }

        @Override
        public Message receive(Session session, MessageConsumer consumer) throws JMSException {
            Message message = consumer.receive(AbstractJmsFunctionalTestCase.this.getTimeout());
            Assert.assertNotNull((Object)message);
            return message;
        }
    }

    protected class ScenarioNotReceive
    extends NonTransactedScenario {
        protected ScenarioNotReceive() {
        }

        @Override
        public Message receive(Session session, MessageConsumer consumer) throws JMSException {
            Message message = consumer.receive(AbstractJmsFunctionalTestCase.this.getSmallTimeout());
            Assert.assertNull((Object)message);
            return message;
        }
    }

    protected class ScenarioRollback
    extends AbstractScenario {
        protected ScenarioRollback() {
        }

        @Override
        public boolean isTransacted() {
            return true;
        }

        @Override
        protected void applyTransaction(Session session) throws JMSException {
            session.rollback();
        }
    }

    protected class ScenarioCommit
    extends AbstractScenario {
        protected ScenarioCommit() {
        }

        @Override
        public boolean isTransacted() {
            return true;
        }

        @Override
        protected void applyTransaction(Session session) throws JMSException {
            session.commit();
        }
    }

    protected class NonTransactedScenario
    extends AbstractScenario {
        protected NonTransactedScenario() {
        }

        @Override
        public boolean isTransacted() {
            return false;
        }

        @Override
        protected void applyTransaction(Session session) throws JMSException {
        }
    }

    protected abstract class AbstractScenario
    implements Scenario {
        private String inputQueue;
        private String outputQueue;
        private boolean persistent;

        protected AbstractScenario() {
            this.inputQueue = AbstractJmsFunctionalTestCase.this.getInboundQueueName();
            this.outputQueue = AbstractJmsFunctionalTestCase.this.getOutboundQueueName();
            this.persistent = false;
        }

        @Override
        public boolean isPersistent() {
            return this.persistent;
        }

        @Override
        public void setPersistent(boolean persistent) {
            this.persistent = persistent;
        }

        @Override
        public String getInputDestinationName() {
            return this.inputQueue;
        }

        @Override
        public String getOutputDestinationName() {
            return this.outputQueue;
        }

        @Override
        public void setInputDestinationName(String inputQueue) {
            this.inputQueue = inputQueue;
        }

        @Override
        public void setOutputDestinationName(String outputQueue) {
            this.outputQueue = outputQueue;
        }

        @Override
        public int getAcknowledge() {
            return 1;
        }

        @Override
        public void send(Session session, MessageProducer producer) throws JMSException {
            producer.send((Message)session.createTextMessage(AbstractJmsFunctionalTestCase.DEFAULT_INPUT_MESSAGE));
            this.applyTransaction(session);
        }

        @Override
        public Message receive(Session session, MessageConsumer consumer) throws JMSException {
            Message message = consumer.receive(AbstractJmsFunctionalTestCase.this.getTimeout());
            Assert.assertNotNull((Object)message);
            Assert.assertTrue((boolean)TextMessage.class.isAssignableFrom(message.getClass()));
            Assert.assertEquals((Object)AbstractJmsFunctionalTestCase.DEFAULT_OUTPUT_MESSAGE, (Object)((TextMessage)message).getText());
            this.applyTransaction(session);
            return message;
        }

        protected abstract void applyTransaction(Session var1) throws JMSException;
    }

    protected static interface Scenario {
        public boolean isPersistent();

        public void setPersistent(boolean var1);

        public String getInputDestinationName();

        public void setInputDestinationName(String var1);

        public String getOutputDestinationName();

        public void setOutputDestinationName(String var1);

        public int getAcknowledge();

        public void send(Session var1, MessageProducer var2) throws JMSException, SystemException, HeuristicMixedException, HeuristicRollbackException, RollbackException;

        public Message receive(Session var1, MessageConsumer var2) throws JMSException, SystemException, HeuristicMixedException, HeuristicRollbackException, RollbackException;

        public boolean isTransacted();
    }
}

