/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms.integration;

import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.client.MuleClient;
import org.mule.api.processor.MessageProcessor;
import org.mule.construct.Flow;
import org.mule.exception.DefaultMessagingExceptionStrategy;
import org.mule.transport.jms.integration.AbstractJmsFunctionalTestCase;
import org.mule.util.concurrent.Latch;

public class JmsExceptionStrategyTestCase
extends AbstractJmsFunctionalTestCase {
    public static final String MESSAGE = "some message";
    public static final int TIMEOUT = 3000;
    public static final int SHORT_TIMEOUT = 500;
    private Latch latch;
    private MuleClient muleClient;
    private static final long LATCH_AWAIT_TIMEOUT = 3000L;

    protected String getConfigFile() {
        return "integration/jms-exception-strategy.xml";
    }

    @Override
    protected void doSetUp() throws Exception {
        this.latch = new Latch();
        this.muleClient = muleContext.getClient();
        DefaultMessagingExceptionStrategy exceptionStrategy = (DefaultMessagingExceptionStrategy)muleContext.getRegistry().lookupFlowConstruct("flowWithoutExceptionStrategyAndTx").getExceptionListener();
        exceptionStrategy.getMessageProcessors().add(new MessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                JmsExceptionStrategyTestCase.this.latch.countDown();
                return event;
            }
        });
    }

    @Test
    public void testInExceptionDoRollbackJmsTx() throws Exception {
        this.muleClient = muleContext.getClient();
        this.muleClient.dispatch("jms://in", (Object)MESSAGE, null);
        this.latch.await(3000L, TimeUnit.MILLISECONDS);
        Flow flow = (Flow)muleContext.getRegistry().get("flowWithoutExceptionStrategyAndTx");
        flow.stop();
        MuleMessage muleMessage = this.muleClient.request("jms://in", 3000L);
        Assert.assertThat((Object)muleMessage, (Matcher)IsNull.notNullValue());
        MuleMessage outboundMessage = this.muleClient.request("jms://out", 500L);
        Assert.assertThat((Object)outboundMessage, (Matcher)IsNull.nullValue());
    }

    @Test
    public void testInExceptionDoRollbackJmsNoTx() throws Exception {
        this.muleClient = muleContext.getClient();
        this.muleClient.dispatch("jms://in2", (Object)MESSAGE, null);
        this.latch.await(3000L, TimeUnit.MILLISECONDS);
        Flow flow = (Flow)muleContext.getRegistry().get("flowWithoutExceptionStrategyAndNoTx");
        flow.stop();
        MuleMessage muleMessage = this.muleClient.request("jms://in2", 3000L);
        Assert.assertThat((Object)muleMessage, (Matcher)IsNull.notNullValue());
        MuleMessage outboundMessage = this.muleClient.request("jms://out2", 500L);
        Assert.assertThat((Object)outboundMessage, (Matcher)IsNull.nullValue());
    }

    @Test
    public void testDefaultStrategyConfigured() throws Exception {
        this.muleClient = muleContext.getClient();
        this.muleClient.dispatch("jms://in3", (Object)MESSAGE, null);
        this.latch.await(3000L, TimeUnit.MILLISECONDS);
        Flow flow = (Flow)muleContext.getRegistry().get("flowWithDefaultStrategyConfigured");
        flow.stop();
        MuleMessage muleMessage = this.muleClient.request("jms://in3", 3000L);
        Assert.assertThat((Object)muleMessage, (Matcher)IsNull.notNullValue());
        MuleMessage outboundMessage = this.muleClient.request("jms://out3", 500L);
        Assert.assertThat((Object)outboundMessage, (Matcher)IsNull.nullValue());
    }

    @Test
    public void testSendExceptionNofication() throws Exception {
        this.muleClient = muleContext.getClient();
        this.muleClient.dispatch("jms://in4", (Object)MESSAGE, null);
        this.latch.await(3000L, TimeUnit.MILLISECONDS);
        Flow flow = (Flow)muleContext.getRegistry().get("flowWithExceptionNotification");
        flow.stop();
        MuleMessage muleMessage = this.muleClient.request("jms://in4", 3000L);
        Assert.assertThat((Object)muleMessage, (Matcher)IsNull.notNullValue());
        MuleMessage exceptionMessage = this.muleClient.request("jms://exception4", 3000L);
        Assert.assertThat((Object)exceptionMessage, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)exceptionMessage.getPayload(), (Matcher)IsNull.notNullValue());
        MuleMessage outboundMessage = this.muleClient.request("jms://out4", 500L);
        Assert.assertThat((Object)outboundMessage, (Matcher)IsNull.nullValue());
    }

    @Test
    public void testFlowConfiguredForDeadLetterQueue() throws Exception {
        this.muleClient = muleContext.getClient();
        this.muleClient.dispatch("jms://in5", (Object)MESSAGE, null);
        this.latch.await(3000L, TimeUnit.MILLISECONDS);
        Flow flow = (Flow)muleContext.getRegistry().get("flowConfiguredForDeadLetterQueue");
        flow.stop();
        MuleMessage muleMessage = this.muleClient.request("jms://in5", 3000L);
        Assert.assertThat((Object)muleMessage, (Matcher)IsNull.nullValue());
        MuleMessage deadLetter = this.muleClient.request("jms://DLQ5", 3000L);
        Assert.assertThat((Object)deadLetter, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)deadLetter.getPayload(), (Matcher)IsNull.notNullValue());
        MuleMessage outboundMessage = this.muleClient.request("jms://out5", 500L);
        Assert.assertThat((Object)outboundMessage, (Matcher)IsNull.nullValue());
    }

    @Test
    public void testFlowConfiguredForDeadLetterQueueTx() throws Exception {
        this.muleClient = muleContext.getClient();
        this.muleClient.dispatch("jms://in6", (Object)MESSAGE, null);
        this.latch.await(3000L, TimeUnit.MILLISECONDS);
        Flow flow = (Flow)muleContext.getRegistry().get("flowConfiguredForDeadLetterQueueTx");
        flow.stop();
        MuleMessage muleMessage = this.muleClient.request("jms://in6", 3000L);
        Assert.assertThat((Object)muleMessage, (Matcher)IsNull.nullValue());
        MuleMessage deadLetter = this.muleClient.request("jms://DLQ6", 3000L);
        Assert.assertThat((Object)deadLetter, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)deadLetter.getPayload(), (Matcher)IsNull.notNullValue());
        MuleMessage outboundMessage = this.muleClient.request("jms://out6", 500L);
        Assert.assertThat((Object)outboundMessage, (Matcher)IsNull.nullValue());
    }
}

