/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms.integration;

import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.transport.NullPayload;
import org.mule.transport.jms.integration.AbstractJmsFunctionalTestCase;

public class JmsTemporaryReplyToTestCase
extends AbstractJmsFunctionalTestCase {
    protected String getConfigFile() {
        return "integration/jms-temporary-replyTo.xml";
    }

    @Test
    public void testTemporaryReplyEnabledSync() throws MuleException {
        LocalMuleClient muleClient = muleContext.getClient();
        MuleMessage response = muleClient.send("vm://in1Sync", (Object)"Test Message", null);
        Assert.assertEquals((Object)"Test Message TestService1", (Object)response.getPayload());
    }

    @Test
    public void testTemporaryReplyDisabledSync() throws MuleException {
        LocalMuleClient muleClient = muleContext.getClient();
        MuleMessage response = muleClient.send("vm://in2Sync", (Object)"Test Message", null);
        Assert.assertEquals((Object)"Test Message", (Object)response.getPayload());
    }

    @Test
    public void testDisableTemporaryReplyOnTheConnector() throws MuleException {
        LocalMuleClient muleClient = muleContext.getClient();
        MuleMessage response = muleClient.send("vm://in3", (Object)"Test Message", null);
        Assert.assertEquals((Object)NullPayload.getInstance(), (Object)response.getPayload());
    }

    @Test
    public void testExplicitReplyToAsyncSet() throws MuleException {
        LocalMuleClient muleClient = muleContext.getClient();
        MuleMessage response = muleClient.send("vm://in4", (Object)"Test Message", null);
        Assert.assertEquals((Object)"Test Message TestService1", (Object)response.getPayload());
    }
}

