/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms.integration;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jms.BytesMessage;
import javax.jms.MapMessage;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.junit.Assert;
import org.junit.Test;
import org.mule.RequestContext;
import org.mule.api.MuleEvent;
import org.mule.tck.testmodels.fruit.Orange;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.transport.jms.integration.AbstractJmsFunctionalTestCase;
import org.mule.transport.jms.integration.SessionEnabledObjectToJMSMessage;
import org.mule.transport.jms.transformers.AbstractJmsTransformer;
import org.mule.transport.jms.transformers.JMSMessageToObject;
import org.mule.util.FileUtils;
import org.mule.util.compression.GZipCompression;

public class JmsTransformersTestCase
extends AbstractJmsFunctionalTestCase {
    private Session session = null;

    protected String getConfigFile() {
        return "integration/jms-transformers.xml";
    }

    @Override
    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.session = this.getConnection(false, false).createSession(false, 1);
    }

    @Override
    protected void doTearDown() throws Exception {
        RequestContext.setEvent(null);
        if (this.session != null) {
            this.session.close();
            this.session = null;
        }
    }

    @Test
    public void testTransformObjectMessage() throws Exception {
        RequestContext.setEvent((MuleEvent)JmsTransformersTestCase.getTestEvent((Object)"test"));
        ObjectMessage oMsg = this.session.createObjectMessage();
        File f = FileUtils.newFile((String)"/some/random/path");
        oMsg.setObject((Serializable)f);
        AbstractJmsTransformer trans = (AbstractJmsTransformer)this.createObject(JMSMessageToObject.class);
        Object result = trans.transform((Object)oMsg);
        Assert.assertTrue((String)"Transformed object should be a File", (boolean)result.getClass().equals(File.class));
        SessionEnabledObjectToJMSMessage trans2 = new SessionEnabledObjectToJMSMessage(this.session);
        trans2.setReturnDataType(DataTypeFactory.create(ObjectMessage.class));
        this.initialiseObject((Object)trans2);
        Object result2 = trans2.transform(f);
        Assert.assertTrue((String)"Transformed object should be an object message", (boolean)(result2 instanceof ObjectMessage));
    }

    @Test
    public void testTransformTextMessage() throws Exception {
        RequestContext.setEvent((MuleEvent)JmsTransformersTestCase.getTestEvent((Object)"test"));
        String text = "This is a test TextMessage";
        TextMessage tMsg = this.session.createTextMessage();
        tMsg.setText(text);
        AbstractJmsTransformer trans = (AbstractJmsTransformer)this.createObject(JMSMessageToObject.class);
        Object result = trans.transform((Object)tMsg);
        Assert.assertTrue((String)"Transformed object should be a string", (boolean)text.equals(result.toString()));
        SessionEnabledObjectToJMSMessage trans2 = new SessionEnabledObjectToJMSMessage(this.session);
        trans2.setReturnDataType(DataTypeFactory.create(TextMessage.class));
        this.initialiseObject((Object)trans2);
        Object result2 = trans2.transform(text);
        Assert.assertTrue((String)"Transformed object should be a TextMessage", (boolean)(result2 instanceof TextMessage));
    }

    @Test
    public void testTransformMapMessage() throws Exception {
        RequestContext.setEvent((MuleEvent)JmsTransformersTestCase.getTestEvent((Object)"test"));
        HashMap<String, Object> p = new HashMap<String, Object>();
        p.put("Key1", "Value1");
        p.put("Key2", new byte[]{1, 2, 3});
        p.put("Key3", new Double(99.999));
        SessionEnabledObjectToJMSMessage trans = new SessionEnabledObjectToJMSMessage(this.session);
        trans.setReturnDataType(DataTypeFactory.create(MapMessage.class));
        this.initialiseObject((Object)trans);
        Object result2 = trans.transform(p);
        Assert.assertTrue((String)"Transformed object should be a MapMessage", (boolean)(result2 instanceof MapMessage));
        MapMessage mMsg = (MapMessage)result2;
        AbstractJmsTransformer trans2 = (AbstractJmsTransformer)this.createObject(JMSMessageToObject.class);
        trans2.setReturnDataType(DataTypeFactory.create(Map.class));
        Object result = trans2.transform((Object)mMsg);
        Assert.assertTrue((String)"Transformed object should be a Map", (boolean)(result instanceof Map));
        Map m = (Map)result;
        Assert.assertEquals((Object)"Value1", m.get("Key1"));
        Assert.assertTrue((boolean)Arrays.equals(new byte[]{1, 2, 3}, (byte[])m.get("Key2")));
        Assert.assertEquals((Object)new Double(99.999), m.get("Key3"));
    }

    @Test
    public void testTransformMapToObjectMessage() throws Exception {
        RequestContext.setEvent((MuleEvent)JmsTransformersTestCase.getTestEvent((Object)"test"));
        HashMap<String, Object> p = new HashMap<String, Object>();
        p.put("Key1", "Value1");
        p.put("Key2", new byte[]{1, 2, 3});
        p.put("Key3", new Double(99.999));
        p.put("Key4", new Orange());
        SessionEnabledObjectToJMSMessage trans = new SessionEnabledObjectToJMSMessage(this.session);
        trans.setReturnDataType(DataTypeFactory.create(ObjectMessage.class));
        this.initialiseObject((Object)trans);
        Object result2 = trans.transform(p);
        Assert.assertTrue((String)"Transformed object should be a ObjectMessage", (boolean)(result2 instanceof ObjectMessage));
        ObjectMessage oMsg = (ObjectMessage)result2;
        AbstractJmsTransformer trans2 = (AbstractJmsTransformer)this.createObject(JMSMessageToObject.class);
        trans2.setReturnDataType(DataTypeFactory.create(Map.class));
        Object result = trans2.transform((Object)oMsg);
        Assert.assertTrue((String)"Transformed object should be a Map", (boolean)(result instanceof Map));
        Map m = (Map)result;
        Assert.assertEquals((Object)"Value1", m.get("Key1"));
        Assert.assertTrue((boolean)Arrays.equals(new byte[]{1, 2, 3}, (byte[])m.get("Key2")));
        Assert.assertEquals((Object)new Double(99.999), m.get("Key3"));
        Assert.assertEquals((Object)new Orange(), m.get("Key4"));
    }

    @Test
    public void testTransformByteMessage() throws Exception {
        RequestContext.setEvent((MuleEvent)JmsTransformersTestCase.getTestEvent((Object)"test"));
        SessionEnabledObjectToJMSMessage trans = new SessionEnabledObjectToJMSMessage(this.session);
        trans.setReturnDataType(DataTypeFactory.create(BytesMessage.class));
        this.initialiseObject((Object)trans);
        String text = "This is a test BytesMessage";
        Object result2 = trans.transform(text.getBytes());
        Assert.assertTrue((String)"Transformed object should be a BytesMessage", (boolean)(result2 instanceof BytesMessage));
        AbstractJmsTransformer trans2 = (AbstractJmsTransformer)this.createObject(JMSMessageToObject.class);
        trans2.setReturnDataType(DataTypeFactory.BYTE_ARRAY);
        BytesMessage bMsg = (BytesMessage)result2;
        Object result = trans2.transform((Object)bMsg);
        Assert.assertTrue((String)"Transformed object should be a byte[]", (boolean)(result instanceof byte[]));
        String res = new String((byte[])result);
        Assert.assertEquals((String)"Source and result should be equal", (Object)text, (Object)res);
    }

    @Test
    public void testTransformStreamMessage() throws Exception {
        RequestContext.setEvent((MuleEvent)JmsTransformersTestCase.getTestEvent((Object)"test"));
        String text = "Test Text";
        int i = 97823;
        double d = 9.232143E126;
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(new Integer(i));
        list.add(new Double(d));
        list.add(text);
        StreamMessage message = this.session.createStreamMessage();
        message.writeString(text);
        message.writeInt(i);
        message.writeDouble(d);
        message.reset();
        AbstractJmsTransformer trans = (AbstractJmsTransformer)this.createObject(JMSMessageToObject.class);
        Object transformedObject = trans.transform((Object)message);
        Assert.assertTrue((String)"Transformed object should be a List", (boolean)(transformedObject instanceof List));
        List result = (List)transformedObject;
        String newText = (String)result.get(0);
        Integer newI = (Integer)result.get(1);
        Double newD = (Double)result.get(2);
        Assert.assertEquals((long)i, (long)newI.intValue());
        Assert.assertEquals((Object)new Double(d), (Object)newD);
        Assert.assertEquals((Object)text, (Object)newText);
    }

    @Test
    public void testCompressedBytesMessage() throws Exception {
        RequestContext.setEvent((MuleEvent)JmsTransformersTestCase.getTestEvent((Object)"test"));
        GZipCompression compressor = new GZipCompression();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (int i = 0; i < 5000; ++i) {
            baos.write(i);
        }
        byte[] originalBytes = baos.toByteArray();
        byte[] compressedBytes = compressor.compressByteArray(originalBytes);
        Assert.assertTrue((String)"Source compressedBytes should be compressed", (boolean)compressor.isCompressed(compressedBytes));
        SessionEnabledObjectToJMSMessage trans = new SessionEnabledObjectToJMSMessage(this.session);
        trans.setReturnDataType(DataTypeFactory.create(BytesMessage.class));
        this.initialiseObject((Object)trans);
        Object result2 = trans.transform(compressedBytes);
        Assert.assertTrue((String)"Transformed object should be a Bytes message", (boolean)(result2 instanceof BytesMessage));
        BytesMessage intermediate = (BytesMessage)result2;
        intermediate.reset();
        byte[] intermediateBytes = new byte[(int)intermediate.getBodyLength()];
        int intermediateSize = intermediate.readBytes(intermediateBytes);
        Assert.assertTrue((String)"Intermediate bytes must be compressed", (boolean)compressor.isCompressed(intermediateBytes));
        Assert.assertTrue((String)"Intermediate bytes must be equal to compressed source", (boolean)Arrays.equals(compressedBytes, intermediateBytes));
        Assert.assertEquals((String)"Intermediate bytes and compressed source must have same size", (long)compressedBytes.length, (long)intermediateSize);
        AbstractJmsTransformer trans2 = (AbstractJmsTransformer)this.createObject(JMSMessageToObject.class);
        trans2.setReturnDataType(DataTypeFactory.BYTE_ARRAY);
        BytesMessage bMsg = this.session.createBytesMessage();
        bMsg.writeBytes(compressedBytes);
        Object result = trans2.transform((Object)bMsg);
        Assert.assertTrue((String)"Transformed object should be a byte[]", (boolean)(result instanceof byte[]));
        Assert.assertTrue((String)"Result should be compressed", (boolean)compressor.isCompressed((byte[])result));
        Assert.assertTrue((String)"Source and result should be equal", (boolean)Arrays.equals(compressedBytes, (byte[])result));
    }
}

