/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms.reliability;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import org.junit.Assert;
import org.junit.Test;
import org.mule.transport.jms.reliability.AbstractJmsReliabilityTestCase;

public class JmsAcknowledgementTestCase
extends AbstractJmsReliabilityTestCase {
    protected String getConfigFile() {
        return "reliability/activemq-config.xml";
    }

    @Test
    public void testAutoAckSync() throws Exception {
        this.acknowledgeMode = 1;
        this.putMessageOnQueue("sanity");
        Message msg = this.readMessageFromQueue("sanity");
        Assert.assertNotNull((Object)msg);
        msg = this.readMessageFromQueue("sanity");
        Assert.assertNull((Object)msg);
    }

    @Test
    public void testClientAckSync() throws Exception {
        this.acknowledgeMode = 2;
        this.putMessageOnQueue("sanity");
        Message msg = this.readMessageFromQueue("sanity");
        Assert.assertNotNull((Object)msg);
        this.closeConsumer();
        msg = this.readMessageFromQueue("sanity");
        Assert.assertNotNull((Object)msg);
        msg.acknowledge();
        this.closeConsumer();
        msg = this.readMessageFromQueue("sanity");
        Assert.assertNull((Object)msg);
    }

    @Test
    public void testAutoAckAsync() throws Exception {
        this.acknowledgeMode = 1;
        this.listenOnQueue("sanity", new MessageListener(){

            public void onMessage(Message message) {
            }
        });
        this.putMessageOnQueue("sanity");
        Thread.sleep(500L);
        this.closeConsumer();
        Message msg = this.readMessageFromQueue("sanity");
        Assert.assertNull((Object)msg);
    }

    @Test
    public void testAutoAckAsyncWithException() throws Exception {
        this.acknowledgeMode = 1;
        this.listenOnQueue("sanity", new MessageListener(){

            public void onMessage(Message message) {
                try {
                    JmsAcknowledgementTestCase.this.session.recover();
                }
                catch (JMSException e) {
                    Assert.fail((String)e.getMessage());
                }
            }
        });
        this.putMessageOnQueue("sanity");
        Thread.sleep(500L);
        this.closeConsumer();
        Message msg = this.readMessageFromQueue("sanity");
        Assert.assertNotNull((Object)msg);
    }

    @Test
    public void testClientAckAsync() throws Exception {
        this.acknowledgeMode = 2;
        this.listenOnQueue("sanity", new MessageListener(){

            public void onMessage(Message message) {
                try {
                    message.acknowledge();
                }
                catch (JMSException e) {
                    Assert.fail((String)e.getMessage());
                }
            }
        });
        this.putMessageOnQueue("sanity");
        Thread.sleep(500L);
        this.closeConsumer();
        Message msg = this.readMessageFromQueue("sanity");
        Assert.assertNull((Object)msg);
    }

    @Test
    public void testClientAckAsyncWithException() throws Exception {
        this.acknowledgeMode = 2;
        this.listenOnQueue("sanity", new MessageListener(){

            public void onMessage(Message message) {
            }
        });
        this.putMessageOnQueue("sanity");
        Thread.sleep(500L);
        this.closeConsumer();
        Message msg = this.readMessageFromQueue("sanity");
        Assert.assertNotNull((Object)msg);
    }
}

