/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms;

import java.util.HashSet;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.Test;
import org.junit.internal.matchers.IsCollectionContaining;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.junit4.FunctionalTestCase;

public class JmsCachingTestCase
extends FunctionalTestCase {
    public static final String TEST_MESSAGE_1 = "test1";
    public static final String TEST_MESSAGE_2 = "test2";

    protected String getConfigFile() {
        return "jms-caching-config.xml";
    }

    @Test
    public void worksWithCaching() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send("vm://testInput", (Object)TEST_MESSAGE_1, null);
        Assert.assertThat((Object)TEST_MESSAGE_1, (Matcher)IsEqual.equalTo((Object)response.getPayloadAsString()));
        response = client.send("vm://testInput", (Object)TEST_MESSAGE_2, null);
        Assert.assertThat((Object)TEST_MESSAGE_2, (Matcher)IsEqual.equalTo((Object)response.getPayloadAsString()));
        HashSet<String> responses = new HashSet<String>();
        response = client.request("vm://testOut", 5000L);
        responses.add(response.getPayloadAsString());
        response = client.request("vm://testOut", 5000L);
        responses.add(response.getPayloadAsString());
        Assert.assertThat(responses, (Matcher)IsCollectionContaining.hasItems((Matcher[])new Matcher[]{IsEqual.equalTo((Object)TEST_MESSAGE_1), IsEqual.equalTo((Object)TEST_MESSAGE_2)}));
    }
}

