/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms;

import javax.jms.Connection;
import javax.jms.JMSException;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.api.MuleMessage;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.listener.ConnectionListener;

public class JmsReconnectionActiveMQTestCase
extends FunctionalTestCase {
    @Rule
    public DynamicPort port = new DynamicPort("port");
    private BrokerService broker;

    protected String getConfigFile() {
        return "jms-reconnection-activemq-config.xml";
    }

    protected void doSetUpBeforeMuleContextCreation() throws Exception {
        this.startBroker();
    }

    protected void doTearDownAfterMuleContextDispose() throws Exception {
        this.stopBroker();
    }

    private void startBroker() throws Exception {
        this.broker = new BrokerService();
        this.broker.setUseJmx(false);
        this.broker.setPersistent(false);
        this.broker.addConnector("tcp://localhost:" + this.port.getValue());
        this.broker.start(true);
        this.broker.waitUntilStarted();
    }

    private void stopBroker() throws Exception {
        this.broker.stop();
        this.broker.waitUntilStopped();
    }

    @Test
    public void reconnectsAfterRestartingActiveMQBroker() throws Exception {
        this.assertMessageRouted();
        ConnectionListener connectionListener = new ConnectionListener(muleContext).setExpectedAction(702).setNumberOfExecutionsRequired(3);
        CustomConnectionFactory.returnInvalidConnections = true;
        this.stopBroker();
        connectionListener.waitUntilNotificationsAreReceived();
        ConnectionListener reconnectionListener = new ConnectionListener(muleContext).setExpectedAction(701).setNumberOfExecutionsRequired(1);
        CustomConnectionFactory.returnInvalidConnections = false;
        this.startBroker();
        reconnectionListener.waitUntilNotificationsAreReceived();
        this.assertMessageRouted();
    }

    private void assertMessageRouted() throws Exception {
        this.runFlow("put", "Test Message");
        MuleMessage message = muleContext.getClient().request("vm://out", 5000L);
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((Object)"Test Message", (Object)message.getPayload());
    }

    private static class CustomConnectionFactory
    extends ActiveMQConnectionFactory {
        public static boolean returnInvalidConnections = false;

        private CustomConnectionFactory() {
        }

        public Connection createConnection() throws JMSException {
            if (returnInvalidConnections) {
                Connection invalidConnection = (Connection)Mockito.mock(Connection.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
                ((Connection)Mockito.doThrow((Throwable)new JMSException("Fail to start connection")).when((Object)invalidConnection)).start();
                return invalidConnection;
            }
            return super.createConnection();
        }
    }
}

