/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms.config;

import javax.jms.ConnectionFactory;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.junit.Assert;
import org.junit.Test;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.transport.jms.JmsConnector;
import org.mule.transport.jms.activemq.ActiveMQJmsConnector;
import org.mule.transport.jms.mulemq.MuleMQJmsConnector;
import org.mule.transport.jms.mulemq.MuleMQXAJmsConnector;
import org.mule.transport.jms.weblogic.WeblogicJmsConnector;
import org.mule.transport.jms.websphere.WebsphereJmsConnector;

public class JmsVendorNamespaceHandlerTestCase
extends FunctionalTestCase {
    public JmsVendorNamespaceHandlerTestCase() {
        this.setStartContext(false);
    }

    protected String getConfigFile() {
        return "jms-vendor-namespace-config.xml";
    }

    @Test
    public void testActiveMqDefault() throws Exception {
        JmsConnector c = (JmsConnector)muleContext.getRegistry().lookupConnector("activeMqConnectorDefaults");
        c.connect();
        Assert.assertNotNull((Object)c);
        Assert.assertTrue((boolean)(c instanceof ActiveMQJmsConnector));
        Assert.assertNotNull((Object)c.getConnectionFactory());
        ConnectionFactory cf = c.getConnectionFactory();
        Assert.assertTrue((boolean)(cf instanceof ActiveMQConnectionFactory));
        Assert.assertEquals((Object)"vm://localhost?broker.persistent=false&broker.useJmx=false", (Object)((ActiveMQConnectionFactory)cf).getBrokerURL());
    }

    @Test
    public void testActiveMqBrokerURL() throws Exception {
        JmsConnector c = (JmsConnector)muleContext.getRegistry().lookupConnector("activeMqConnectorBroker");
        try {
            c.connect();
        }
        catch (Exception e) {
            // empty catch block
        }
        Assert.assertNotNull((Object)c);
        Assert.assertTrue((boolean)(c instanceof ActiveMQJmsConnector));
        Assert.assertNotNull((Object)c.getConnectionFactory());
        ConnectionFactory cf = c.getConnectionFactory();
        Assert.assertTrue((boolean)(cf instanceof ActiveMQConnectionFactory));
        Assert.assertEquals((Object)"tcp://localhost:1234", (Object)((ActiveMQConnectionFactory)cf).getBrokerURL());
    }

    @Test
    public void testWeblogicDefaultConfig() throws Exception {
        JmsConnector c = (JmsConnector)muleContext.getRegistry().lookupConnector("weblogicConnector");
        Assert.assertNotNull((Object)c);
        Assert.assertTrue((boolean)(c instanceof WeblogicJmsConnector));
    }

    @Test
    public void testWebsphereDefaultConfig() throws Exception {
        JmsConnector c = (JmsConnector)muleContext.getRegistry().lookupConnector("websphereConnector");
        Assert.assertNotNull((Object)c);
        Assert.assertTrue((boolean)(c instanceof WebsphereJmsConnector));
    }

    @Test
    public void testMuleMQDefaultConfig() throws Exception {
        JmsConnector c = (JmsConnector)muleContext.getRegistry().lookupConnector("muleMqConnector");
        Assert.assertNotNull((Object)c);
        Assert.assertTrue((boolean)(c instanceof MuleMQJmsConnector));
        Assert.assertEquals((Object)"nsp://localhost:9000", (Object)((MuleMQJmsConnector)c).getRealmURL());
        Assert.assertEquals((Object)"1.1", (Object)((MuleMQJmsConnector)c).getSpecification());
    }

    @Test
    public void testMuleMQBrokerURL() throws Exception {
        JmsConnector c = (JmsConnector)muleContext.getRegistry().lookupConnector("muleMqConnectorBroker");
        Assert.assertNotNull((Object)c);
        Assert.assertTrue((boolean)(c instanceof MuleMQJmsConnector));
        Assert.assertEquals((Object)"nsp://localhost:1234", (Object)((MuleMQJmsConnector)c).getRealmURL());
    }

    @Test
    public void testMuleMQXaDefaultConfig() throws Exception {
        JmsConnector c = (JmsConnector)muleContext.getRegistry().lookupConnector("muleMqXaConnector");
        Assert.assertNotNull((Object)c);
        Assert.assertTrue((boolean)(c instanceof MuleMQXAJmsConnector));
        Assert.assertEquals((Object)"nsp://localhost:9000", (Object)((MuleMQXAJmsConnector)c).getRealmURL());
    }

    @Test
    public void testMuleMQXaBrokerURL() throws Exception {
        JmsConnector c = (JmsConnector)muleContext.getRegistry().lookupConnector("muleMqXaConnectorBroker");
        Assert.assertNotNull((Object)c);
        Assert.assertTrue((boolean)(c instanceof MuleMQXAJmsConnector));
        Assert.assertEquals((Object)"nsp://localhost:1234", (Object)((MuleMQJmsConnector)c).getRealmURL());
    }
}

