/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms.integration;

import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.transport.jms.integration.AbstractJmsFunctionalTestCase;

public class JmsConnectorJndiTestCase
extends AbstractJmsFunctionalTestCase {
    protected String getConfigFile() {
        return "integration/jms-jndi-config.xml";
    }

    @Test
    public void testConnectionFactoryFromJndi() throws Exception {
    }

    @Test
    public void testQueueFromJndi() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        client.dispatch("ep_jndi-queue", (Object)"INPUT MESSAGE", null);
        MuleMessage result = client.request("vm://out", 5000L);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"INPUT MESSAGE", (Object)result.getPayloadAsString());
    }

    @Test
    public void testTopicFromJndi() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        client.dispatch("ep_jndi-topic", (Object)"INPUT MESSAGE", null);
        MuleMessage result = client.request("vm://out", 5000L);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"INPUT MESSAGE", (Object)result.getPayloadAsString());
    }

    @Test
    public void testNonJndiDestination() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        client.dispatch("ep_non-jndi-queue", (Object)"INPUT MESSAGE", null);
        MuleMessage result = client.request("vm://out", 5000L);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"INPUT MESSAGE", (Object)result.getPayloadAsString());
    }

    @Test
    public void testNonJndiDestinationOptional() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        client.dispatch("ep_non-jndi-queue-optional-jndi", (Object)"INPUT MESSAGE", null);
        MuleMessage result = client.request("vm://out", 5000L);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"INPUT MESSAGE", (Object)result.getPayloadAsString());
    }

    @Test
    public void testNonJndiDestinationForce() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        client.dispatch("ep_non-jndi-queue-force-jndi", (Object)"INPUT MESSAGE", null);
        MuleMessage result = client.request("vm://out", 5000L);
        Assert.assertNull((String)"Attempt to look up a non-existant JNDI Destination should have failed", (Object)result);
    }

    @Test
    public void testQueueFromJndiWithJndiNameResolver() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        client.dispatch("ep_jndi-queue-with-jndi-name-resolver", (Object)"INPUT MESSAGE", null);
        MuleMessage result = client.request("vm://out", 5000L);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"INPUT MESSAGE", (Object)result.getPayloadAsString());
    }

    @Test
    public void testTopicFromJndiWithJndiNameResolver() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        client.dispatch("ep_jndi-topic-with-jndi-name-resolver", (Object)"INPUT MESSAGE", null);
        MuleMessage result = client.request("vm://out", 5000L);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"INPUT MESSAGE", (Object)result.getPayloadAsString());
    }

    @Test
    public void testNonJndiDestinationWithJndiNameResolver() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        client.dispatch("ep_non-jndi-queue-with-jndi-name-resolver", (Object)"INPUT MESSAGE", null);
        MuleMessage result = client.request("vm://out", 5000L);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"INPUT MESSAGE", (Object)result.getPayloadAsString());
    }

    @Test
    public void testNonJndiDestinationOptionalWithJndiNameResolver() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        client.dispatch("ep_non-jndi-queue-optional-jndi-with-jndi-name-resolver", (Object)"INPUT MESSAGE", null);
        MuleMessage result = client.request("vm://out", 5000L);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"INPUT MESSAGE", (Object)result.getPayloadAsString());
    }

    @Test
    public void testNonJndiDestinationForceWithJndiNameResolver() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        client.dispatch("ep_non-jndi-queue-force-jndi-with-jndi-name-resolver", (Object)"INPUT MESSAGE", null);
        MuleMessage result = client.request("vm://out", 5000L);
        Assert.assertNull((String)"Attempt to look up a non-existant JNDI Destination should have failed", (Object)result);
    }
}

