/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms.integration;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import org.junit.Assert;
import org.junit.Test;
import org.mule.transport.jms.integration.AbstractJmsFunctionalTestCase;

public class JmsMuleSideDurableTopicTestCase
extends AbstractJmsFunctionalTestCase {
    public static final String CONNECTOR1_NAME = "jmsConnectorC1";
    AbstractJmsFunctionalTestCase.Scenario scenarioNoTx = new AbstractJmsFunctionalTestCase.NonTransactedScenario(){

        @Override
        public String getInputDestinationName() {
            return JmsMuleSideDurableTopicTestCase.this.getJmsConfig().getBroadcastDestinationName();
        }

        @Override
        public void send(Session session, MessageProducer producer) throws JMSException {
            producer.send((Message)session.createTextMessage("INPUT MESSAGE"));
        }

        @Override
        public Message receive(Session session, MessageConsumer consumer) throws JMSException {
            Message message = consumer.receive(JmsMuleSideDurableTopicTestCase.this.getTimeout());
            Assert.assertNotNull((Object)message);
            Assert.assertTrue((boolean)TextMessage.class.isAssignableFrom(message.getClass()));
            Assert.assertEquals((Object)((TextMessage)message).getText(), (Object)"OUTPUT MESSAGE");
            return message;
        }
    };

    protected String getConfigFile() {
        return "integration/jms-muleside-durable-topic.xml";
    }

    @Test
    public void testMuleDurableSubscriber() throws Exception {
        this.send(this.scenarioNoTx);
        this.receive(this.scenarioNoTx);
        this.receive(this.scenarioNoTx);
        muleContext.getRegistry().lookupConnector(CONNECTOR1_NAME).stop();
        Assert.assertEquals((Object)muleContext.getRegistry().lookupConnector(CONNECTOR1_NAME).isStarted(), (Object)false);
        log.info((Object)"jmsConnectorC1 is stopped");
        this.send(this.scenarioNoTx);
        muleContext.getRegistry().lookupConnector(CONNECTOR1_NAME).start();
        log.info((Object)"jmsConnectorC1 is started");
        this.receive(this.scenarioNoTx);
        this.receive(this.scenarioNoTx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(AbstractJmsFunctionalTestCase.Scenario scenario) throws Exception {
        TopicConnection connection = null;
        try {
            connection = (TopicConnection)this.getConnection(true, false);
            connection.start();
            TopicSession session = null;
            try {
                session = connection.createTopicSession(scenario.isTransacted(), scenario.getAcknowledge());
                Topic destination = session.createTopic(scenario.getInputDestinationName());
                TopicPublisher publisher = null;
                try {
                    publisher = session.createPublisher(destination);
                    publisher.setDeliveryMode(2);
                    scenario.send((Session)session, (MessageProducer)publisher);
                }
                finally {
                    if (publisher != null) {
                        publisher.close();
                    }
                }
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }
}

