/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms.reliability;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.mule.transport.jms.integration.AbstractJmsFunctionalTestCase;
import org.mule.transport.jms.integration.activemq.ActiveMQJmsConfiguration;

public abstract class AbstractJmsReliabilityTestCase
extends AbstractJmsFunctionalTestCase {
    protected int acknowledgeMode = 1;
    protected int deliveryMode = 2;
    protected Connection connection;
    protected Session session;
    protected MessageConsumer consumer;

    public AbstractJmsReliabilityTestCase() {
        this.setMultipleProviders(false);
    }

    @Override
    protected void doTearDown() throws Exception {
        this.closeConsumer();
        super.doTearDown();
    }

    protected void closeConsumer() throws Exception {
        if (this.consumer != null) {
            this.consumer.close();
            this.consumer = null;
            this.session.close();
            this.session = null;
            this.connection.close();
            this.connection = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putMessageOnQueue(String queueName) throws Exception {
        ActiveMQJmsConfiguration jmsConfig = new ActiveMQJmsConfiguration();
        Connection connection = null;
        try {
            connection = jmsConfig.getConnection(false, false);
            connection.start();
            Session session = null;
            try {
                session = connection.createSession(false, this.acknowledgeMode);
                Queue destination = session.createQueue(queueName);
                MessageProducer producer = null;
                try {
                    producer = session.createProducer((Destination)destination);
                    producer.setDeliveryMode(this.deliveryMode);
                    TextMessage msg = session.createTextMessage("INPUT MESSAGE");
                    msg.setJMSExpiration(0L);
                    producer.send((Message)msg);
                }
                finally {
                    if (producer != null) {
                        producer.close();
                    }
                }
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    protected Message readMessageFromQueue(String queueName) throws Exception {
        if (this.consumer == null) {
            this.createConsumer(queueName);
        }
        return this.consumer.receive(this.getTimeout());
    }

    protected void listenOnQueue(String queueName, MessageListener listener) throws Exception {
        if (this.consumer == null) {
            this.createConsumer(queueName);
        }
        this.consumer.setMessageListener(listener);
    }

    protected void createConsumer(String queueName) throws Exception {
        this.connection = this.getConnection(false, false);
        this.connection.start();
        this.session = this.connection.createSession(false, this.acknowledgeMode);
        this.consumer = this.session.createConsumer((Destination)this.session.createQueue(queueName));
    }
}

