/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms.vendors;

import javax.jms.ConnectionFactory;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.junit.Assert;
import org.junit.Test;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.transport.jms.DefaultJmsTopicResolver;
import org.mule.transport.jms.JmsConnector;
import org.mule.transport.jms.activemq.ActiveMQJmsConnector;
import org.mule.transport.jms.redelivery.JmsXRedeliveryHandler;
import org.mule.transport.jms.test.TestRedeliveryHandler;

public class ActiveMQJmsConnectorTestCase
extends FunctionalTestCase {
    protected String getConfigFile() {
        return "integration/activemq-config.xml";
    }

    @Test
    public void testConfigurationDefaults() throws Exception {
        JmsConnector c = (JmsConnector)muleContext.getRegistry().lookupConnector("jmsConnector");
        Assert.assertNotNull((Object)c);
        Assert.assertFalse((boolean)c.isEagerConsumer());
        ConnectionFactory cf = c.getConnectionFactory();
        Assert.assertTrue((boolean)(cf instanceof ActiveMQConnectionFactory));
        Assert.assertEquals((Object)"vm://localhost?broker.persistent=false&broker.useJmx=false", (Object)((ActiveMQConnectionFactory)cf).getBrokerURL());
        Assert.assertNotNull((Object)c.getTopicResolver());
        Assert.assertTrue((String)"Wrong topic resolver configured on the connector.", (boolean)(c.getTopicResolver() instanceof DefaultJmsTopicResolver));
    }

    @Test
    public void testDefaultActiveMqConnectorConfig() throws Exception {
        JmsConnector c = (JmsConnector)muleContext.getRegistry().lookupConnector("activeMqJmsConnector");
        Assert.assertNotNull((Object)c);
        Assert.assertTrue((boolean)(c instanceof ActiveMQJmsConnector));
        Assert.assertNotNull((Object)c.getConnectionFactory());
        Assert.assertTrue((boolean)(c.getConnectionFactory() instanceof ActiveMQConnectionFactory));
        Assert.assertEquals((long)1L, (long)c.getAcknowledgementMode());
        Assert.assertNull((Object)c.getUsername());
        Assert.assertNull((Object)c.getPassword());
        Assert.assertNotNull((Object)c.getRedeliveryHandlerFactory());
        Assert.assertTrue((boolean)(c.getRedeliveryHandlerFactory().create() instanceof JmsXRedeliveryHandler));
        Assert.assertFalse((boolean)c.isDurable());
        Assert.assertFalse((boolean)c.isNoLocal());
        Assert.assertFalse((boolean)c.isPersistentDelivery());
        Assert.assertEquals((long)0L, (long)c.getMaxRedelivery());
        Assert.assertFalse((boolean)c.isCacheJmsSessions());
        Assert.assertFalse((boolean)c.isEagerConsumer());
        Assert.assertEquals((Object)"1.0.2b", (Object)c.getSpecification());
    }

    @Test
    public void testCustomActiveMqConnectorConfig() throws Exception {
        JmsConnector c = (JmsConnector)muleContext.getRegistry().lookupConnector("customActiveMqJmsConnector");
        Assert.assertNotNull((Object)c);
        Assert.assertTrue((boolean)(c instanceof ActiveMQJmsConnector));
        Assert.assertNotNull((Object)c.getConnectionFactory());
        Assert.assertTrue((boolean)(c.getConnectionFactory() instanceof ActiveMQConnectionFactory));
        Assert.assertEquals((long)3L, (long)c.getAcknowledgementMode());
        Assert.assertNull((Object)c.getUsername());
        Assert.assertNull((Object)c.getPassword());
        Assert.assertNotNull((Object)c.getRedeliveryHandlerFactory());
        Assert.assertTrue((boolean)(c.getRedeliveryHandlerFactory().create() instanceof TestRedeliveryHandler));
        Assert.assertEquals((Object)"myClient", (Object)c.getClientId());
        Assert.assertTrue((boolean)c.isDurable());
        Assert.assertTrue((boolean)c.isNoLocal());
        Assert.assertTrue((boolean)c.isPersistentDelivery());
        Assert.assertEquals((long)5L, (long)c.getMaxRedelivery());
        Assert.assertTrue((boolean)c.isCacheJmsSessions());
        Assert.assertFalse((boolean)c.isEagerConsumer());
        Assert.assertEquals((Object)"1.1", (Object)c.getSpecification());
    }
}

