/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms;

import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.junit.Rule;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class AbstractBrokerFunctionalTestCase
extends FunctionalTestCase {
    @Rule
    public DynamicPort port = new DynamicPort("port");
    protected BrokerService broker;
    protected TransportConnector transportConnector;
    protected String url;

    protected void doSetUpBeforeMuleContextCreation() throws Exception {
        this.url = "tcp://localhost:" + this.port.getValue();
        this.startBroker();
    }

    protected void doTearDownAfterMuleContextDispose() throws Exception {
        this.stopBroker();
    }

    protected void startBroker() throws Exception {
        this.broker = new BrokerService();
        this.broker.setUseJmx(false);
        this.broker.setPersistent(false);
        this.transportConnector = this.broker.addConnector(this.url);
        this.broker.start(true);
        this.broker.waitUntilStarted();
    }

    protected void stopBroker() throws Exception {
        this.broker.stop();
        this.broker.waitUntilStopped();
    }

    protected int getConnectionsCount() {
        return this.transportConnector.getConnections().size();
    }
}

