/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms;

import java.lang.reflect.Proxy;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.transport.jms.CustomCachingConnectionFactory;

@SmallTest
public class CustomCachingConnectionFactoryTestCase
extends AbstractMuleTestCase {
    public static final String USERNAME = "username";
    public static final String PASSWORD = "password";
    private ConnectionFactory delegate = (ConnectionFactory)Mockito.mock(ConnectionFactory.class);
    private Connection connection = (Connection)Mockito.mock(Connection.class);

    @Test
    public void createsConnection() throws Exception {
        Mockito.when((Object)this.delegate.createConnection()).thenReturn((Object)this.connection);
        CustomCachingConnectionFactory cachingConnectionFactory = new CustomCachingConnectionFactory(this.delegate, null, null);
        Connection actualConnection = cachingConnectionFactory.createConnection();
        Assert.assertThat((Object)actualConnection, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(Proxy.class)));
        Mockito.verify((Object)this.delegate.createConnection());
    }

    @Test
    public void createsConnectionWithUsername() throws Exception {
        Mockito.when((Object)this.delegate.createConnection(USERNAME, null)).thenReturn((Object)this.connection);
        CustomCachingConnectionFactory cachingConnectionFactory = new CustomCachingConnectionFactory(this.delegate, USERNAME, null);
        Connection actualConnection = cachingConnectionFactory.createConnection();
        Assert.assertThat((Object)actualConnection, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(Proxy.class)));
        Mockito.verify((Object)this.delegate.createConnection(USERNAME, null));
    }

    @Test
    public void createsConnectionWithPassword() throws Exception {
        Mockito.when((Object)this.delegate.createConnection(null, PASSWORD)).thenReturn((Object)this.connection);
        CustomCachingConnectionFactory cachingConnectionFactory = new CustomCachingConnectionFactory(this.delegate, null, PASSWORD);
        Connection actualConnection = cachingConnectionFactory.createConnection();
        Assert.assertThat((Object)actualConnection, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(Proxy.class)));
        Mockito.verify((Object)this.delegate.createConnection(null, PASSWORD));
    }

    @Test
    public void createsConnectionWithUsernameAndPassword() throws Exception {
        Mockito.when((Object)this.delegate.createConnection(USERNAME, PASSWORD)).thenReturn((Object)this.connection);
        CustomCachingConnectionFactory cachingConnectionFactory = new CustomCachingConnectionFactory(this.delegate, USERNAME, PASSWORD);
        Connection actualConnection = cachingConnectionFactory.createConnection();
        Assert.assertThat((Object)actualConnection, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(Proxy.class)));
        Mockito.verify((Object)this.delegate.createConnection(USERNAME, PASSWORD));
    }

    @Test(expected=IllegalStateException.class)
    public void throwsErrorCreatingConnectionWithCustomUsernameAndPassword() throws Exception {
        CustomCachingConnectionFactory cachingConnectionFactory = new CustomCachingConnectionFactory(this.delegate, USERNAME, PASSWORD);
        cachingConnectionFactory.createConnection(null, null);
    }

    @Test
    public void createsSingleConnection() throws Exception {
        Mockito.when((Object)this.delegate.createConnection(USERNAME, PASSWORD)).thenReturn((Object)this.connection).thenReturn(null);
        CustomCachingConnectionFactory cachingConnectionFactory = new CustomCachingConnectionFactory(this.delegate, USERNAME, PASSWORD);
        Connection connection1 = cachingConnectionFactory.createConnection();
        connection1.close();
        Connection connection2 = cachingConnectionFactory.createConnection();
        Assert.assertThat((Object)connection2, (Matcher)IsEqual.equalTo((Object)connection1));
    }

    @Test
    public void cachesSession() throws Exception {
        Mockito.when((Object)this.delegate.createConnection(USERNAME, PASSWORD)).thenReturn((Object)this.connection).thenReturn(null);
        Session session = (Session)Mockito.mock(Session.class);
        Mockito.when((Object)this.connection.createSession(false, 1)).thenReturn((Object)session).thenReturn(null);
        CustomCachingConnectionFactory cachingConnectionFactory = new CustomCachingConnectionFactory(this.delegate, USERNAME, PASSWORD);
        Connection connection1 = cachingConnectionFactory.createConnection();
        Session session1 = connection1.createSession(false, 1);
        session1.close();
        Session session2 = connection1.createSession(false, 1);
        Assert.assertThat((Object)session1, (Matcher)IsEqual.equalTo((Object)session2));
    }

    @Test
    public void cachesProducer() throws Exception {
        Destination destination = (Destination)Mockito.mock(Destination.class);
        Mockito.when((Object)this.delegate.createConnection(USERNAME, PASSWORD)).thenReturn((Object)this.connection).thenReturn(null);
        Session session = (Session)Mockito.mock(Session.class);
        Mockito.when((Object)this.connection.createSession(false, 1)).thenReturn((Object)session).thenReturn(null);
        MessageProducer producer = (MessageProducer)Mockito.mock(MessageProducer.class);
        Mockito.when((Object)session.createProducer(destination)).thenReturn((Object)producer).thenReturn(null);
        CustomCachingConnectionFactory cachingConnectionFactory = new CustomCachingConnectionFactory(this.delegate, USERNAME, PASSWORD);
        Connection connection1 = cachingConnectionFactory.createConnection();
        Session session1 = connection1.createSession(false, 1);
        MessageProducer producer1 = session1.createProducer(destination);
        producer1.close();
        session1.close();
        Session session2 = connection1.createSession(false, 1);
        MessageProducer producer2 = session2.createProducer(destination);
        Assert.assertThat((Object)producer1.toString(), (Matcher)IsEqual.equalTo((Object)producer2.toString()));
    }
}

