/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.jms.JMSException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.api.DefaultMuleException;
import org.mule.api.config.ExceptionReader;
import org.mule.config.ExceptionHelper;
import org.mule.config.i18n.MessageFactory;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.transport.jms.JmsExceptionReader;

@SmallTest
public class JmsExceptionReaderTestCase
extends AbstractMuleTestCase {
    @Before
    public void registerExceptionReader() {
        ExceptionHelper.registerExceptionReader((ExceptionReader)new JmsExceptionReader());
    }

    @Test
    public void testNestedExceptionRetrieval() throws Exception {
        Exception testException = this.getException();
        Throwable t = ExceptionHelper.getRootException((Throwable)testException);
        Assert.assertNotNull((Object)t);
        Assert.assertEquals((Object)"blah", (Object)t.getMessage());
        Assert.assertNull((Object)t.getCause());
        t = ExceptionHelper.getRootMuleException((Throwable)testException);
        Assert.assertNotNull((Object)t);
        Assert.assertEquals((Object)"bar", (Object)t.getMessage());
        Assert.assertNotNull((Object)t.getCause());
        List l = ExceptionHelper.getExceptionsAsList((Throwable)testException);
        Assert.assertEquals((long)4L, (long)l.size());
        Map info = ExceptionHelper.getExceptionInfo((Throwable)testException);
        Assert.assertNotNull((Object)info);
        Assert.assertEquals((long)1L, (long)info.size());
        Assert.assertEquals((Object)"1234", info.get("JMS Code"));
    }

    private Exception getException() {
        JMSException e = new JMSException("Jms error", "1234");
        e.setLinkedException((Exception)new IOException("blah"));
        return new DefaultMuleException(MessageFactory.createStaticMessage((String)"foo"), (Throwable)new DefaultMuleException(MessageFactory.createStaticMessage((String)"bar"), (Throwable)e));
    }
}

