/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageFormatException;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import org.apache.activemq.command.ActiveMQBytesMessage;
import org.apache.activemq.command.ActiveMQMapMessage;
import org.apache.activemq.command.ActiveMQObjectMessage;
import org.apache.activemq.command.ActiveMQStreamMessage;
import org.apache.activemq.command.ActiveMQTextMessage;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.collections.ResettableIterator;
import org.apache.commons.collections.iterators.IteratorEnumeration;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.testmodels.fruit.BananaFactory;
import org.mule.tck.testmodels.fruit.Orange;
import org.mule.transport.jms.JmsMessageUtils;

public class JmsMessageUtilsTestCase
extends AbstractMuleTestCase {
    public static final String ENCODING = "UTF-8";

    @Test
    public void testHeaders() {
        Assert.assertSame((Object)"identifier", (Object)JmsMessageUtils.encodeHeader((String)"identifier"));
        Assert.assertSame((Object)"_identifier", (Object)JmsMessageUtils.encodeHeader((String)"_identifier"));
        Assert.assertSame((Object)"identifier_", (Object)JmsMessageUtils.encodeHeader((String)"identifier_"));
        Assert.assertSame((Object)"ident_ifier", (Object)JmsMessageUtils.encodeHeader((String)"ident_ifier"));
        Assert.assertEquals((Object)"_identifier", (Object)JmsMessageUtils.encodeHeader((String)"-identifier"));
        Assert.assertEquals((Object)"identifier_", (Object)JmsMessageUtils.encodeHeader((String)"identifier-"));
        Assert.assertEquals((Object)"ident_ifier", (Object)JmsMessageUtils.encodeHeader((String)"ident-ifier"));
        Assert.assertEquals((Object)"_ident_ifier_", (Object)JmsMessageUtils.encodeHeader((String)"-ident_ifier-"));
        Assert.assertEquals((Object)"_ident_ifier_", (Object)JmsMessageUtils.encodeHeader((String)"-ident-ifier-"));
    }

    @Test
    public void testTextMessageNullContent() throws Exception {
        TextMessage mockMessage = (TextMessage)Mockito.mock(TextMessage.class);
        Mockito.when((Object)mockMessage.getText()).thenReturn(null);
        byte[] result = JmsMessageUtils.toByteArray((Message)mockMessage, (String)"1.0.2b", (String)ENCODING);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((String)"Should return an empty byte array.", (long)0L, (long)result.length);
        ((TextMessage)Mockito.verify((Object)mockMessage)).getText();
    }

    @Test
    public void testByteMessageNullContentInJmsVersion_1_0_1() throws Exception {
        BytesMessage mockMessage1 = (BytesMessage)Mockito.mock(BytesMessage.class);
        Mockito.when((Object)mockMessage1.readBytes((byte[])Matchers.anyObject())).thenReturn((Object)-1);
        byte[] result1 = JmsMessageUtils.toByteArray((Message)mockMessage1, (String)"1.0.2b", (String)ENCODING);
        Assert.assertNotNull((Object)result1);
        Assert.assertEquals((String)"Should return an empty byte array.", (long)0L, (long)result1.length);
        ((BytesMessage)Mockito.verify((Object)mockMessage1)).reset();
    }

    @Test
    public void testByteMessageNullContentInJmsVersion_1_1() throws Exception {
        BytesMessage mockMessage2 = (BytesMessage)Mockito.mock(BytesMessage.class);
        Mockito.when((Object)mockMessage2.getBodyLength()).thenReturn((Object)0L);
        byte[] result2 = JmsMessageUtils.toByteArray((Message)mockMessage2, (String)"1.1", (String)ENCODING);
        Assert.assertNotNull((Object)result2);
        Assert.assertEquals((String)"Should return an empty byte array.", (long)0L, (long)result2.length);
        ((BytesMessage)Mockito.verify((Object)mockMessage2)).reset();
    }

    @Test
    public void testStreamMessageSerialization() throws Exception {
        Session session = (Session)Mockito.mock(Session.class);
        Mockito.when((Object)session.createStreamMessage()).thenReturn((Object)new ActiveMQStreamMessage());
        ArrayList<Object> data = new ArrayList<Object>();
        data.add(Boolean.TRUE);
        data.add(new Byte("1"));
        data.add(new Short("2"));
        data.add(new Character('3'));
        data.add(new Integer("4"));
        data.add(new Float("6"));
        data.add(new Double("7"));
        data.add(new String("8"));
        data.add(null);
        data.add(new byte[]{9, 10});
        StreamMessage result = (StreamMessage)JmsMessageUtils.toMessage(data, (Session)session);
        result.reset();
        Assert.assertEquals((Object)Boolean.TRUE, (Object)result.readObject());
        Assert.assertEquals((Object)new Byte("1"), (Object)result.readObject());
        Assert.assertEquals((Object)new Short("2"), (Object)result.readObject());
        Assert.assertEquals((Object)new Character('3'), (Object)result.readObject());
        Assert.assertEquals((Object)new Integer("4"), (Object)result.readObject());
        Assert.assertEquals((Object)new Float("6"), (Object)result.readObject());
        Assert.assertEquals((Object)new Double("7"), (Object)result.readObject());
        Assert.assertEquals((Object)new String("8"), (Object)result.readObject());
        Assert.assertNull((Object)result.readObject());
        Assert.assertTrue((boolean)Arrays.equals(new byte[]{9, 10}, (byte[])result.readObject()));
    }

    @Test(expected=MessageFormatException.class)
    public void testStreamMessageSerializationWithInvalidType() throws Exception {
        Session session = null;
        session = (Session)Mockito.mock(Session.class);
        Mockito.when((Object)session.createStreamMessage()).thenReturn((Object)new ActiveMQStreamMessage());
        ArrayList<Object> data = new ArrayList<Object>();
        data.add(new Object());
        JmsMessageUtils.toMessage(data, (Session)session);
    }

    @Test
    public void testMapMessageWithNullValue() throws Exception {
        Object[] keys = new String[]{"key", "null"};
        ResettableIterator keyIterator = IteratorUtils.arrayIterator((Object[])keys);
        IteratorEnumeration keyEnumeration = new IteratorEnumeration((Iterator)keyIterator);
        MapMessage mockMessage1 = (MapMessage)Mockito.mock(MapMessage.class);
        Mockito.when((Object)mockMessage1.getMapNames()).thenReturn((Object)keyEnumeration);
        Mockito.when((Object)mockMessage1.getObject("key")).thenReturn((Object)"value");
        Mockito.when((Object)mockMessage1.getObject("null")).thenReturn(null);
        Object result = JmsMessageUtils.toObject((Message)mockMessage1, (String)"1.1", (String)ENCODING);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof Map));
        Map map = (Map)result;
        Assert.assertEquals((Object)"value", map.get("key"));
        Assert.assertNull(map.get("null"));
    }

    @Test
    public void testConvertsValidMapWithSimpleValuesToMapMessage() throws JMSException {
        Session session = (Session)Mockito.mock(Session.class);
        Mockito.when((Object)session.createMapMessage()).thenReturn((Object)new ActiveMQMapMessage());
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("value1", new Float(4.0f));
        data.put("value2", new byte[]{1, 2, 3});
        data.put("value3", "value3");
        data.put("value4", new Double(67.9));
        data.put("value5", true);
        data.put("value6", null);
        Message message = JmsMessageUtils.toMessage(data, (Session)session);
        Assert.assertTrue((boolean)(message instanceof MapMessage));
        MapMessage mapMessage = (MapMessage)message;
        Assert.assertEquals((float)new Float(4.0f).floatValue(), (float)mapMessage.getFloat("value1"), (float)0.0f);
        Assert.assertTrue((boolean)Arrays.equals(new byte[]{1, 2, 3}, mapMessage.getBytes("value2")));
        Assert.assertEquals((Object)"value3", (Object)mapMessage.getString("value3"));
        Assert.assertEquals((double)new Double(67.9), (double)mapMessage.getDouble("value4"), (double)0.0);
        Assert.assertTrue((boolean)mapMessage.getBoolean("value5"));
        Assert.assertNull((Object)mapMessage.getObject("value6"));
    }

    @Test
    public void testConvertsMapWithSerializableValueIntoObjectMessage() throws Exception {
        Session session = (Session)Mockito.mock(Session.class);
        Mockito.when((Object)session.createObjectMessage()).thenReturn((Object)new ActiveMQObjectMessage());
        HashMap<String, Orange> data = new HashMap<String, Orange>();
        data.put("orange", new Orange());
        Message message = JmsMessageUtils.toMessage(data, (Session)session);
        Assert.assertTrue((boolean)(message instanceof ObjectMessage));
        ObjectMessage objectMessage = (ObjectMessage)message;
        Map values = (Map)((Object)objectMessage.getObject());
        Assert.assertEquals((Object)new Orange(), values.get("orange"));
    }

    @Test
    public void testConvertingMapIncludingNotValidNotSerializableValueThrowsException() throws Exception {
        Session session = (Session)Mockito.mock(Session.class);
        Mockito.when((Object)session.createObjectMessage()).thenReturn((Object)new ActiveMQObjectMessage());
        HashMap<String, BananaFactory> data = new HashMap<String, BananaFactory>();
        data.put("notserializable", new BananaFactory());
        try {
            JmsMessageUtils.toMessage(data, (Session)session);
            Assert.fail((String)"Attempt to send a non-serializable object in a map should fail");
        }
        catch (Exception expected) {
            Assert.assertTrue((boolean)(expected.getCause() instanceof NotSerializableException));
        }
    }

    @Test
    public void testConvertingStringToTextMessage() throws JMSException {
        String text = "Hello world";
        Session session = (Session)Mockito.mock(Session.class);
        ActiveMQTextMessage textMessage = new ActiveMQTextMessage();
        textMessage.setText(text);
        Mockito.when((Object)session.createTextMessage(text)).thenReturn((Object)textMessage);
        TextMessage message = (TextMessage)JmsMessageUtils.toMessage((Object)text, (Session)session);
        Assert.assertEquals((Object)textMessage, (Object)message);
        ((Session)Mockito.verify((Object)session, (VerificationMode)Mockito.times((int)1))).createTextMessage(text);
    }

    @Test
    public void testConvertingByteArrayToBytesMessage() throws JMSException {
        Session session = (Session)Mockito.mock(Session.class);
        Mockito.when((Object)session.createBytesMessage()).thenReturn((Object)new ActiveMQBytesMessage());
        byte[] bytesArray = new byte[]{1, 2};
        BytesMessage message = (BytesMessage)JmsMessageUtils.toMessage((Object)bytesArray, (Session)session);
        message.reset();
        byte[] bytesArrayResult = new byte[(int)message.getBodyLength()];
        int length = message.readBytes(bytesArrayResult);
        Assert.assertEquals((long)2L, (long)length);
        Assert.assertEquals((long)bytesArray[0], (long)bytesArrayResult[0]);
        Assert.assertEquals((long)bytesArray[1], (long)bytesArrayResult[1]);
    }

    @Test
    public void testConvertingSerializableToObjectMessage() throws JMSException {
        Session session = (Session)Mockito.mock(Session.class);
        Mockito.when((Object)session.createObjectMessage()).thenReturn((Object)new ActiveMQObjectMessage());
        String OBJECT_ID = "id1234";
        ObjectMessage message = (ObjectMessage)JmsMessageUtils.toMessage((Object)new SerializableObject("id1234"), (Session)session);
        Serializable serializable = message.getObject();
        Assert.assertTrue((boolean)(serializable instanceof SerializableObject));
        Assert.assertEquals((Object)"id1234", (Object)((SerializableObject)serializable).id);
    }

    @Test
    public void testConvertingMessageToMessageReturnsSameObject() throws JMSException {
        Message original = (Message)Mockito.mock(Message.class);
        Message result = JmsMessageUtils.toMessage((Object)original, null);
        Assert.assertSame((Object)original, (Object)result);
    }

    @Test(expected=JMSException.class)
    public void testConvertingInvalidTypeThrowsException() throws JMSException {
        JmsMessageUtils.toMessage((Object)new Object(), null);
    }

    private static class SerializableObject
    implements Serializable {
        private static final long serialVersionUID = -4865136673252075014L;
        private String id;

        public SerializableObject(String id) {
            this.id = id;
        }

        private void readObject(ObjectInputStream aInputStream) throws ClassNotFoundException, IOException {
            aInputStream.defaultReadObject();
        }

        private void writeObject(ObjectOutputStream aOutputStream) throws IOException {
            aOutputStream.defaultWriteObject();
        }
    }
}

