/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms;

import java.util.Collection;
import javax.jms.Connection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleMessage;
import org.mule.api.transport.MessageReceiver;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.transport.jms.AbstractBrokerFunctionalTestCase;
import org.mule.transport.jms.JmsConnector;
import org.mule.transport.jms.MultiConsumerJmsMessageReceiver;

public class JmsReconnectForeverTestCase
extends AbstractBrokerFunctionalTestCase {
    private static final int CONSUMER_COUNT = 1;
    private static final int POLL_DELAY_MILLIS = 100;
    private static final int POLL_TIMEOUT_MILLIS = 5000;
    private JmsConnector connector;
    private Connection connection;

    protected String getConfigFile() {
        return "jms-reconnect-forever-config.xml";
    }

    @Override
    protected void startBroker() throws Exception {
        super.startBroker();
        this.connection = new ActiveMQConnectionFactory(this.url).createQueueConnection();
    }

    @Override
    protected void stopBroker() throws Exception {
        this.connection.close();
        super.stopBroker();
    }

    @Test
    public void reconnectAllConsumers() throws Exception {
        this.connector = (JmsConnector)muleContext.getRegistry().lookupObject("activeMQConnector");
        Collection receivers = this.connector.getReceivers().values();
        Assert.assertTrue((receivers != null && receivers.size() == 2 ? 1 : 0) != 0);
        PollingProber prober = new PollingProber(5000L, 100L);
        prober.check(new Probe(){

            public boolean isSatisfied() {
                boolean allConsumersSet = true;
                for (MessageReceiver messageReceiver : JmsReconnectForeverTestCase.this.connector.getReceivers().values()) {
                    MultiConsumerJmsMessageReceiver receiver = (MultiConsumerJmsMessageReceiver)messageReceiver;
                    allConsumersSet = allConsumersSet && 1 == receiver.consumers.size();
                }
                return allConsumersSet;
            }

            public String describeFailure() {
                return "Not all consumers were created.";
            }
        });
        this.assertConsumersConnected();
        this.assertMessageRouted("put1");
        this.assertMessageRouted("put2");
    }

    private void assertConsumersConnected() {
        for (MessageReceiver messageReceiver : this.connector.getReceivers().values()) {
            MultiConsumerJmsMessageReceiver receiver = (MultiConsumerJmsMessageReceiver)messageReceiver;
            for (MultiConsumerJmsMessageReceiver.SubReceiver consumer : receiver.consumers) {
                Assert.assertThat((Object)consumer.connected, (Matcher)Matchers.is((Object)true));
            }
        }
    }

    private void assertMessageRouted(String entryFlow) throws Exception {
        this.runFlow(entryFlow, "Test Message");
        MuleMessage message = muleContext.getClient().request("vm://out" + entryFlow, 5000L);
        Assert.assertThat((Object)message, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)message.getPayloadAsString(), (Matcher)Matchers.is((Object)"Test Message"));
    }
}

