/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms;

import javax.jms.Connection;
import javax.jms.JMSException;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.api.MuleMessage;
import org.mule.tck.listener.ConnectionListener;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.tck.probe.Prober;
import org.mule.transport.jms.AbstractBrokerFunctionalTestCase;
import org.mule.transport.jms.JmsConnector;

public class JmsReconnectionActiveMQTestCase
extends AbstractBrokerFunctionalTestCase {
    private static final long PROBER_TIMEOUT = 3000L;
    private Prober prober;
    private JmsConnector jmsConnector;

    protected String getConfigFile() {
        return "jms-reconnection-activemq-config.xml";
    }

    @Before
    public void doSetUp() {
        this.prober = new PollingProber(3000L, 100L);
    }

    @Test
    public void reconnectsAfterRestartingActiveMQBroker() throws Exception {
        this.jmsConnector = (JmsConnector)muleContext.getRegistry().lookupConnector("jmsConnector");
        this.assertMessageRouted();
        ConnectionListener connectionListener = new ConnectionListener(muleContext).setExpectedAction(702).setNumberOfExecutionsRequired(3);
        CustomConnectionFactory.returnInvalidConnections = true;
        this.stopBroker();
        connectionListener.waitUntilNotificationsAreReceived();
        Assert.assertTrue((boolean)this.jmsConnector.isStopped());
        CustomConnectionFactory.returnInvalidConnections = false;
        this.startBroker();
        this.prober.check(new Probe(){

            public boolean isSatisfied() {
                return JmsReconnectionActiveMQTestCase.this.jmsConnector.isStarted();
            }

            public String describeFailure() {
                return "JMS connector did not restart";
            }
        });
        this.assertMessageRouted();
    }

    private void assertMessageRouted() throws Exception {
        this.runFlow("put", "Test Message");
        MuleMessage message = muleContext.getClient().request("vm://out", 5000L);
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((Object)"Test Message", (Object)message.getPayload());
    }

    private static class CustomConnectionFactory
    extends ActiveMQConnectionFactory {
        public static boolean returnInvalidConnections = false;

        private CustomConnectionFactory() {
        }

        public Connection createConnection() throws JMSException {
            if (returnInvalidConnections) {
                Connection invalidConnection = (Connection)Mockito.mock(Connection.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
                ((Connection)Mockito.doThrow((Throwable)new JMSException("Fail to start connection")).when((Object)invalidConnection)).start();
                return invalidConnection;
            }
            return super.createConnection();
        }
    }
}

