/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms;

import java.util.Collection;
import javax.jms.Connection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleMessage;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.transport.jms.AbstractBrokerFunctionalTestCase;
import org.mule.transport.jms.JmsConnector;
import org.mule.transport.jms.MultiConsumerJmsMessageReceiver;

public class JmsReconnectionTestCase
extends AbstractBrokerFunctionalTestCase {
    private static final int CONSUMER_COUNT = 4;
    private static final int TIMEOUT_MILLIS = 5000;
    private static final String PAYLOAD = "HELLO";
    private MultiConsumerJmsMessageReceiver receiver;
    private Connection connection;

    protected String getConfigFile() {
        return "jms-reconnection-config.xml";
    }

    @Override
    protected void startBroker() throws Exception {
        super.startBroker();
        this.connection = new ActiveMQConnectionFactory(this.url).createQueueConnection();
    }

    @Override
    protected void stopBroker() throws Exception {
        this.connection.close();
        super.stopBroker();
    }

    @Test
    public void reconnectAllConsumers() throws Exception {
        this.assertMessageRouted();
        JmsConnector connector = (JmsConnector)muleContext.getRegistry().lookupObject("activemqconnector");
        Collection receivers = connector.getReceivers().values();
        Assert.assertTrue((receivers != null && receivers.size() == 1 ? 1 : 0) != 0);
        this.receiver = (MultiConsumerJmsMessageReceiver)receivers.iterator().next();
        this.assertConsumersCount();
        this.stopBroker();
        PollingProber prober = new PollingProber(5000L, 500L);
        prober.check(new Probe(){

            public boolean isSatisfied() {
                return ((JmsReconnectionTestCase)JmsReconnectionTestCase.this).receiver.consumers.isEmpty();
            }

            public String describeFailure() {
                return "consumers were never released";
            }
        });
        this.startBroker();
        prober.check(new Probe(){

            public boolean isSatisfied() {
                try {
                    JmsReconnectionTestCase.this.assertConsumersCount();
                    return true;
                }
                catch (AssertionError e) {
                    return false;
                }
            }

            public String describeFailure() {
                return "receivers never came back";
            }
        });
        this.assertMessageRouted();
    }

    private void assertConsumersCount() {
        Assert.assertEquals((long)4L, (long)this.receiver.consumers.size());
        for (MultiConsumerJmsMessageReceiver.SubReceiver consumer : this.receiver.consumers) {
            Assert.assertTrue((boolean)consumer.connected);
        }
    }

    private void assertMessageRouted() throws Exception {
        this.runFlow("put", PAYLOAD);
        MuleMessage message = muleContext.getClient().request("vm://out", 5000L);
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((Object)PAYLOAD, (Object)message.getPayload());
    }
}

