/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms;

import java.util.HashSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsCollectionContaining;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.transport.NullPayload;

public class JmsTransactionalCachingTestCase
extends FunctionalTestCase {
    public static final String TEST_MESSAGE_1 = "test1";
    public static final String TEST_MESSAGE_2 = "test2";
    public static final String TEST_MESSAGE_3 = "test3";

    protected String getConfigFile() {
        return "jms-transactional-caching-config.xml";
    }

    @Test
    public void cachesSession() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send("vm://testInput", (Object)TEST_MESSAGE_1, null);
        Assert.assertThat((Object)TEST_MESSAGE_1, (Matcher)IsEqual.equalTo((Object)response.getPayloadAsString()));
        response = client.send("vm://testInput", (Object)TEST_MESSAGE_2, null);
        Assert.assertThat((Object)NullPayload.getInstance(), (Matcher)IsEqual.equalTo((Object)response.getPayload()));
        response = client.send("vm://testInput", (Object)TEST_MESSAGE_3, null);
        Assert.assertThat((Object)TEST_MESSAGE_3, (Matcher)IsEqual.equalTo((Object)response.getPayloadAsString()));
        HashSet<String> responses = new HashSet<String>();
        response = client.request("vm://testOut", 5000L);
        responses.add(response.getPayloadAsString());
        response = client.request("vm://testOut", 5000L);
        responses.add(response.getPayloadAsString());
        Assert.assertThat(responses, (Matcher)IsCollectionContaining.hasItems((Matcher[])new Matcher[]{IsEqual.equalTo((Object)TEST_MESSAGE_1), IsEqual.equalTo((Object)TEST_MESSAGE_3)}));
    }

    public static class AbortMessageOnEventCount {
        private static AtomicInteger counter = new AtomicInteger(0);

        public Object process(Object payload) {
            int currentCounter = counter.incrementAndGet();
            if (currentCounter % 2 == 0) {
                throw new RuntimeException("Expected exception to abort the transaction during the test");
            }
            return payload;
        }
    }
}

