/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.transport.Connector;
import org.mule.execution.MessageProcessingManager;
import org.mule.retry.policies.SimpleRetryPolicyTemplate;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.transport.jms.JmsConnector;
import org.mule.transport.jms.MultiConsumerJmsMessageReceiver;

@RunWith(value=MockitoJUnitRunner.class)
public class MultiConsumerJmsMessageReceiverTest
extends AbstractMuleTestCase {
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private JmsConnector mockJmsConnector;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private FlowConstruct mockFlowConstruct;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private InboundEndpoint mockInboundEndpoint;

    @Test
    public void testTopicReceiverShouldBeStartedOnlyInPrimaryNode() throws Exception {
        Mockito.when((Object)this.mockJmsConnector.getTopicResolver().isTopic((ImmutableEndpoint)this.mockInboundEndpoint, true)).thenReturn((Object)true);
        Mockito.when((Object)this.mockInboundEndpoint.getConnector()).thenReturn((Object)this.mockJmsConnector);
        MultiConsumerJmsMessageReceiver messageReceiver = new MultiConsumerJmsMessageReceiver((Connector)this.mockJmsConnector, this.mockFlowConstruct, this.mockInboundEndpoint);
        Assert.assertThat((String)"receiver must be started only in primary node", (Object)messageReceiver.shouldConsumeInEveryNode(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void testQueueReceiverShouldBeStartedInEveryNode() throws Exception {
        Mockito.when((Object)this.mockJmsConnector.getTopicResolver().isTopic((ImmutableEndpoint)this.mockInboundEndpoint, true)).thenReturn((Object)false);
        Mockito.when((Object)this.mockInboundEndpoint.getConnector()).thenReturn((Object)this.mockJmsConnector);
        MultiConsumerJmsMessageReceiver messageReceiver = new MultiConsumerJmsMessageReceiver((Connector)this.mockJmsConnector, this.mockFlowConstruct, this.mockInboundEndpoint);
        Assert.assertThat((String)"receiver must be started only in primary node", (Object)messageReceiver.shouldConsumeInEveryNode(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void messageListenerNotSetTwiceOnMessageReceiver() throws Exception {
        Mockito.when((Object)this.mockJmsConnector.getTopicResolver().isTopic((ImmutableEndpoint)this.mockInboundEndpoint, true)).thenReturn((Object)false);
        Mockito.when((Object)this.mockJmsConnector.getNumberOfConsumers()).thenReturn((Object)1);
        MessageConsumer mockMessageConsumer = (MessageConsumer)Mockito.mock(TestMessageConsumer.class, (Answer)Mockito.CALLS_REAL_METHODS);
        Mockito.when((Object)this.mockJmsConnector.getJmsSupport().createConsumer((Session)Matchers.any(Session.class), (Destination)Matchers.any(Destination.class), Matchers.anyString(), Matchers.anyBoolean(), Matchers.anyString(), Matchers.anyBoolean(), (ImmutableEndpoint)Matchers.any(InboundEndpoint.class))).thenReturn((Object)mockMessageConsumer);
        Mockito.when((Object)this.mockInboundEndpoint.getConnector()).thenReturn((Object)this.mockJmsConnector);
        Mockito.when((Object)this.mockInboundEndpoint.getMuleContext().getRegistry().get("_muleMessageProcessingManager")).thenReturn(Mockito.mock(MessageProcessingManager.class));
        SimpleRetryPolicyTemplate retryPolicyTemplate = new SimpleRetryPolicyTemplate();
        retryPolicyTemplate.setMuleContext(this.mockJmsConnector.getMuleContext());
        Mockito.when((Object)this.mockInboundEndpoint.getRetryPolicyTemplate()).thenReturn((Object)retryPolicyTemplate);
        Mockito.when(this.mockInboundEndpoint.getProperties().get("durable")).thenReturn((Object)"false");
        Mockito.when(this.mockInboundEndpoint.getProperties().get("durableName")).thenReturn(null);
        MultiConsumerJmsMessageReceiver messageReceiver = new MultiConsumerJmsMessageReceiver((Connector)this.mockJmsConnector, this.mockFlowConstruct, this.mockInboundEndpoint);
        messageReceiver.initialise();
        messageReceiver.doStart();
        ((MessageConsumer)Mockito.verify((Object)mockMessageConsumer)).setMessageListener((MessageListener)Matchers.any(MessageListener.class));
        Mockito.reset((Object[])new MessageConsumer[]{mockMessageConsumer});
        messageReceiver.startSubReceivers();
        ((MessageConsumer)Mockito.verify((Object)mockMessageConsumer, (VerificationMode)Mockito.never())).setMessageListener((MessageListener)Matchers.any(MessageListener.class));
    }

    private abstract class TestMessageConsumer
    implements MessageConsumer {
        private MessageListener messageListener;

        private TestMessageConsumer() {
        }

        public MessageListener getMessageListener() throws JMSException {
            return this.messageListener;
        }

        public void setMessageListener(MessageListener messageListener) throws JMSException {
            this.messageListener = messageListener;
        }
    }
}

