/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSession;
import javax.jms.Session;
import org.apache.activemq.command.ActiveMQTextMessage;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.retry.RetryPolicyTemplate;
import org.mule.api.transport.Connector;
import org.mule.endpoint.EndpointURIEndpointBuilder;
import org.mule.retry.policies.SimpleRetryPolicyTemplate;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.transport.jms.Jms102bSupport;
import org.mule.transport.jms.Jms11Support;
import org.mule.transport.jms.JmsConnector;
import org.mule.transport.jms.JmsSupport;
import org.springframework.jms.connection.SingleConnectionFactory;

@RunWith(value=MockitoJUnitRunner.class)
public class OutboundSessionAndProducerReuseTestCase
extends AbstractMuleContextTestCase {
    private static String USERNAME = "username";
    private static String PASSWORD = "password";
    private JmsConnector connector;
    @Mock
    private ConnectionFactory connectionFactory;
    @Mock
    private Connection connection;
    @Mock
    private Queue queue;
    private ExceptionListener connectionExceptionListener;
    private String connectionClientId;
    private OutboundEndpoint outboundEndpoint;
    private CountDownLatch messageSentLatch = new CountDownLatch(1);

    protected void doSetUp() throws Exception {
        super.doSetUp();
        Mockito.when((Object)this.connectionFactory.createConnection()).thenReturn((Object)this.connection);
        Mockito.when((Object)this.connectionFactory.createConnection(Matchers.anyString(), Matchers.anyString())).thenReturn((Object)this.connection);
        this.setupMockSession();
        this.connector = new JmsConnector(muleContext);
        this.connector.setConnectionFactory(this.connectionFactory);
        SimpleRetryPolicyTemplate retryPolicyTemplate = new SimpleRetryPolicyTemplate();
        retryPolicyTemplate.setMuleContext(muleContext);
        this.connector.setRetryPolicyTemplate((RetryPolicyTemplate)retryPolicyTemplate);
        this.connector.setJmsSupport((JmsSupport)new Jms11Support(this.connector));
        EndpointURIEndpointBuilder epBuilder = new EndpointURIEndpointBuilder("jms://out", muleContext);
        epBuilder.setConnector((Connector)this.connector);
        this.outboundEndpoint = epBuilder.buildOutboundEndpoint();
    }

    private void setupMockSession() throws JMSException {
        Mockito.when((Object)this.connection.createSession(false, 1)).then((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                return OutboundSessionAndProducerReuseTestCase.this.createSessionMock();
            }
        });
        ((Connection)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                OutboundSessionAndProducerReuseTestCase.this.connectionExceptionListener = (ExceptionListener)invocation.getArguments()[0];
                return null;
            }
        }).when((Object)this.connection)).setExceptionListener((ExceptionListener)Matchers.any(ExceptionListener.class));
        Mockito.when((Object)this.connection.getExceptionListener()).thenAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                return OutboundSessionAndProducerReuseTestCase.this.connectionExceptionListener;
            }
        });
        ((Connection)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                OutboundSessionAndProducerReuseTestCase.this.connectionClientId = (String)invocation.getArguments()[0];
                return null;
            }
        }).when((Object)this.connection)).setClientID((String)Matchers.any(String.class));
        Mockito.when((Object)this.connection.getClientID()).thenAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                return OutboundSessionAndProducerReuseTestCase.this.connectionClientId;
            }
        });
    }

    private QueueSession createSessionMock() throws JMSException {
        QueueSession mock = (QueueSession)Mockito.mock(QueueSession.class);
        Mockito.when((Object)mock.createProducer((Destination)Matchers.any(Destination.class))).then((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                return OutboundSessionAndProducerReuseTestCase.this.createProducerMock();
            }
        });
        Mockito.when((Object)mock.createConsumer((Destination)Matchers.any(Destination.class))).then((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                return Mockito.mock(MessageConsumer.class);
            }
        });
        Mockito.when((Object)mock.createTextMessage(Matchers.anyString())).then((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                ActiveMQTextMessage msg = new ActiveMQTextMessage();
                msg.setText((String)invocation.getArguments()[0]);
                return msg;
            }
        });
        return mock;
    }

    private MessageProducer createProducerMock() throws JMSException {
        MessageProducer mock = (MessageProducer)Mockito.mock(MessageProducer.class);
        ((MessageProducer)Mockito.doAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                OutboundSessionAndProducerReuseTestCase.this.messageSentLatch.countDown();
                return null;
            }
        }).when((Object)mock)).send((Message)Matchers.any(Message.class), Matchers.anyInt(), Matchers.anyInt(), Matchers.anyLong());
        return mock;
    }

    @Test
    public void connectionFactoryWrappedJMS11() throws Exception {
        Assert.assertThat((Object)this.connector.getConnectionFactory(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)this.connectionFactory)));
        this.connector.initialise();
        this.connector.connect();
        Assert.assertThat((Object)this.connector.getConnectionFactory(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(SingleConnectionFactory.class)));
        Assert.assertThat((Object)((SingleConnectionFactory)this.connector.getConnectionFactory()).getTargetConnectionFactory(), (Matcher)CoreMatchers.is((Object)this.connectionFactory));
    }

    @Test
    public void connectionFactoryNotWrappedJMS102b() throws Exception {
        this.connectionFactory = (ConnectionFactory)Mockito.mock(QueueConnectionFactory.class);
        this.connector.setConnectionFactory(this.connectionFactory);
        this.connector.setJmsSupport((JmsSupport)new Jms102bSupport(this.connector));
        Assert.assertThat((Object)this.connector.getConnectionFactory(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)this.connectionFactory)));
        this.connector.initialise();
        this.connector.connect();
        Assert.assertThat((Object)this.connector.getConnectionFactory(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)this.connectionFactory)));
    }

    @Test
    public void connectionFactoryNotWrappedJMS102bCachingEnabled() throws Exception {
        this.connectionFactory = (ConnectionFactory)Mockito.mock(QueueConnectionFactory.class);
        this.connector.setCacheJmsSessions(true);
        this.connector.setConnectionFactory(this.connectionFactory);
        this.connector.setJmsSupport((JmsSupport)new Jms102bSupport(this.connector));
        Assert.assertThat((Object)this.connector.getConnectionFactory(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)this.connectionFactory)));
        this.connector.initialise();
        this.connector.connect();
        Assert.assertThat((Object)this.connector.getConnectionFactory(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)this.connectionFactory)));
    }

    @Test
    public void connectionFactoryNotWrappedCachingDisabled() throws Exception {
        this.connectionFactory = (ConnectionFactory)Mockito.mock(QueueConnectionFactory.class);
        this.connector.setCacheJmsSessions(false);
        this.connector.setConnectionFactory(this.connectionFactory);
        this.connector.setJmsSupport((JmsSupport)new Jms102bSupport(this.connector));
        Assert.assertThat((Object)this.connector.getConnectionFactory(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)this.connectionFactory)));
        this.connector.initialise();
        this.connector.connect();
        Assert.assertThat((Object)this.connector.getConnectionFactory(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)this.connectionFactory)));
    }

    @Test
    public void connection() throws Exception {
        this.connector.initialise();
        this.connector.connect();
        Assert.assertThat((Object)this.connector.getConnection(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)this.connection))));
        ((ConnectionFactory)Mockito.verify((Object)this.connectionFactory, (VerificationMode)Mockito.times((int)1))).createConnection();
    }

    @Test
    public void clientId() throws Exception {
        String clientId = "foo";
        this.connector.setClientId(clientId);
        this.connector.initialise();
        this.connector.connect();
        Assert.assertThat((Object)this.connector.getConnection().getClientID(), (Matcher)CoreMatchers.is((Object)clientId));
    }

    @Test
    public void sessionReuse() throws Exception {
        this.connector.initialise();
        this.connector.connect();
        Session session1 = this.connector.createSession((ImmutableEndpoint)this.outboundEndpoint);
        session1.close();
        Session session2 = this.connector.createSession((ImmutableEndpoint)this.outboundEndpoint);
        Assert.assertThat((Object)session1, (Matcher)CoreMatchers.equalTo((Object)session2));
    }

    @Test
    public void sessionNotReusedJMS102b() throws Exception {
        QueueConnectionFactory connectionFactory = (QueueConnectionFactory)Mockito.mock(QueueConnectionFactory.class);
        QueueConnection queueConnection = (QueueConnection)Mockito.mock(QueueConnection.class);
        Mockito.when((Object)connectionFactory.createQueueConnection()).thenReturn((Object)queueConnection);
        Mockito.when((Object)queueConnection.createQueueSession(false, 1)).then((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                return OutboundSessionAndProducerReuseTestCase.this.createSessionMock();
            }
        });
        this.connector.setCacheJmsSessions(false);
        this.connector.setConnectionFactory((ConnectionFactory)connectionFactory);
        this.connector.setJmsSupport((JmsSupport)new Jms102bSupport(this.connector));
        this.connector.initialise();
        this.connector.connect();
        Session session1 = this.connector.createSession((ImmutableEndpoint)this.outboundEndpoint);
        session1.close();
        Session session2 = this.connector.createSession((ImmutableEndpoint)this.outboundEndpoint);
        Assert.assertThat((Object)session1, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)session2)));
    }

    @Test
    public void sessionNotReusedCachingDisabled() throws Exception {
        this.connector.setCacheJmsSessions(false);
        this.connector.initialise();
        this.connector.connect();
        Session session1 = this.connector.createSession((ImmutableEndpoint)this.outboundEndpoint);
        session1.close();
        Session session2 = this.connector.createSession((ImmutableEndpoint)this.outboundEndpoint);
        Assert.assertThat((Object)session1, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)session2)));
    }

    @Test
    public void producersReused() throws Exception {
        this.connector.initialise();
        this.connector.connect();
        Session session = this.connector.createSession((ImmutableEndpoint)this.outboundEndpoint);
        MessageProducer producer1 = session.createProducer((Destination)this.queue);
        producer1.close();
        MessageProducer producer2 = session.createProducer((Destination)this.queue);
        producer2.close();
        Assert.assertThat((Object)producer1.toString(), (Matcher)CoreMatchers.equalTo((Object)producer2.toString()));
    }

    @Test
    public void consumersNotReused() throws Exception {
        this.connector.initialise();
        this.connector.connect();
        Session session = this.connector.createSession((ImmutableEndpoint)this.outboundEndpoint);
        MessageConsumer consumer1 = session.createConsumer((Destination)this.queue);
        consumer1.close();
        MessageConsumer consumer2 = session.createConsumer((Destination)this.queue);
        consumer2.close();
        Assert.assertThat((Object)consumer1.toString(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)consumer2.toString())));
    }

    @Test
    public void send() throws Exception {
        this.connector.initialise();
        this.connector.connect();
        this.connector.start();
        Mockito.reset((Object[])new ConnectionFactory[]{this.connectionFactory});
        this.outboundEndpoint.process(OutboundSessionAndProducerReuseTestCase.getTestEvent((Object)"Test Message"));
        ((ConnectionFactory)Mockito.verify((Object)this.connectionFactory, (VerificationMode)Mockito.times((int)0))).createConnection();
        ((Connection)Mockito.verify((Object)this.connection, (VerificationMode)Mockito.times((int)1))).createSession(Matchers.anyBoolean(), Matchers.anyInt());
        Assert.assertTrue((boolean)this.messageSentLatch.await(5000L, TimeUnit.MILLISECONDS));
    }

    @Test
    public void usernamePasswordConfiguredViaCachingConnectionFactory() throws Exception {
        Jms11Support jms11Support = (Jms11Support)Mockito.mock(Jms11Support.class);
        this.connector.setJmsSupport((JmsSupport)jms11Support);
        Mockito.when((Object)jms11Support.isCacheJmsSessions()).thenReturn((Object)true);
        this.connector.setUsername(USERNAME);
        this.connector.setPassword(PASSWORD);
        this.connector.initialise();
        this.connector.connect();
        ((Jms11Support)Mockito.verify((Object)jms11Support, (VerificationMode)Mockito.times((int)1))).createConnection(this.connector.getConnectionFactory());
    }

    @Test
    public void usernamePasswordNoCaching() throws Exception {
        Jms11Support jms11Support = (Jms11Support)Mockito.mock(Jms11Support.class);
        this.connector.setJmsSupport((JmsSupport)jms11Support);
        Mockito.when((Object)jms11Support.isCacheJmsSessions()).thenReturn((Object)false);
        this.connector.setUsername(USERNAME);
        this.connector.setPassword(PASSWORD);
        this.connector.initialise();
        this.connector.connect();
        ((Jms11Support)Mockito.verify((Object)jms11Support, (VerificationMode)Mockito.times((int)1))).createConnection(this.connectionFactory, USERNAME, PASSWORD);
    }
}

