/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms;

import javax.jms.MessageConsumer;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.transport.Connector;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.transport.jms.XaTransactedJmsMessageReceiver;

public class XaPollingTimeoutTestCase
extends FunctionalTestCase {
    private static MessageConsumer messageConsumer = (MessageConsumer)Mockito.mock(MessageConsumer.class);

    protected String getConfigFile() {
        return "xa-polling-timeout-config.xml";
    }

    @Test
    public void usesConfiguredXaPollingTimeout() throws Exception {
        PollingProber prober = new PollingProber(5000L, 100L);
        prober.check(new Probe(){

            public boolean isSatisfied() {
                try {
                    ((MessageConsumer)Mockito.verify((Object)messageConsumer, (VerificationMode)Mockito.atLeastOnce())).receive(10000L);
                    return true;
                }
                catch (Throwable e) {
                    return false;
                }
            }

            public String describeFailure() {
                return "Message consumer was not invoked using the right timeout";
            }
        });
    }

    public static class TestXaTransactedJmsMessageReceiver
    extends XaTransactedJmsMessageReceiver {
        public TestXaTransactedJmsMessageReceiver(Connector connector, FlowConstruct flowConstruct, InboundEndpoint endpoint) throws CreateException {
            super(connector, flowConstruct, endpoint);
        }

        protected MessageConsumer createConsumer() throws Exception {
            return messageConsumer;
        }
    }
}

