/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms;

import java.lang.reflect.UndeclaredThrowableException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.transaction.Transaction;
import org.mule.api.transport.Connector;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.transaction.TransactionCoordination;
import org.mule.transport.jms.JmsConnector;
import org.mule.transport.jms.XaTransactedJmsMessageReceiver;

@RunWith(value=MockitoJUnitRunner.class)
public class XaTransactedJmsMessageReceiverTest
extends AbstractMuleTestCase {
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private JmsConnector mockJmsConnector;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private FlowConstruct mockFlowConstruct;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private InboundEndpoint mockInboundEndpoint;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private MessageConsumer messageConsumer;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private Transaction transaction;

    @After
    public void clearInterruptedFlag() {
        Thread.interrupted();
    }

    @Test
    public void testTopicReceiverShouldBeStartedOnlyInPrimaryNode() throws Exception {
        Mockito.when((Object)this.mockJmsConnector.getTopicResolver().isTopic((ImmutableEndpoint)this.mockInboundEndpoint)).thenReturn((Object)true);
        Mockito.when((Object)this.mockInboundEndpoint.getConnector()).thenReturn((Object)this.mockJmsConnector);
        XaTransactedJmsMessageReceiver messageReceiver = new XaTransactedJmsMessageReceiver((Connector)this.mockJmsConnector, this.mockFlowConstruct, this.mockInboundEndpoint);
        Assert.assertThat((String)"receiver must be started only in primary node", (Object)messageReceiver.shouldConsumeInEveryNode(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void testQueueReceiverShouldBeStartedInEveryNode() throws Exception {
        Mockito.when((Object)this.mockJmsConnector.getTopicResolver().isTopic((ImmutableEndpoint)this.mockInboundEndpoint)).thenReturn((Object)false);
        Mockito.when((Object)this.mockInboundEndpoint.getConnector()).thenReturn((Object)this.mockJmsConnector);
        XaTransactedJmsMessageReceiver messageReceiver = new XaTransactedJmsMessageReceiver((Connector)this.mockJmsConnector, this.mockFlowConstruct, this.mockInboundEndpoint);
        Assert.assertThat((String)"receiver must be started only in primary node", (Object)messageReceiver.shouldConsumeInEveryNode(), (Matcher)Is.is((Object)true));
    }

    private void doDisconnectExceptionTest(final Exception exceptionToThrow) throws Exception {
        Mockito.when((Object)this.mockJmsConnector.getTopicResolver().isTopic((ImmutableEndpoint)this.mockInboundEndpoint)).thenReturn((Object)false);
        Mockito.when((Object)this.mockInboundEndpoint.getConnector()).thenReturn((Object)this.mockJmsConnector);
        XaTransactedJmsMessageReceiver messageReceiver = (XaTransactedJmsMessageReceiver)Mockito.spy((Object)new XaTransactedJmsMessageReceiver((Connector)this.mockJmsConnector, this.mockFlowConstruct, this.mockInboundEndpoint));
        ((XaTransactedJmsMessageReceiver)Mockito.doReturn((Object)this.messageConsumer).when((Object)messageReceiver)).createConsumer();
        Mockito.when((Object)this.messageConsumer.receive(messageReceiver.timeout)).thenAnswer((Answer)new Answer<Message>(){

            public Message answer(InvocationOnMock invocation) throws Exception {
                Thread.currentThread().interrupt();
                throw exceptionToThrow;
            }
        });
        ((Transaction)Mockito.doAnswer((Answer)new Answer(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                Assert.assertThat((Object)Thread.currentThread().isInterrupted(), (Matcher)Is.is((Object)true));
                return null;
            }
        }).when((Object)this.transaction)).setRollbackOnly();
        TransactionCoordination.getInstance().bindTransaction(this.transaction);
        messageReceiver.getMessages();
        ((Transaction)Mockito.verify((Object)this.transaction)).setRollbackOnly();
    }

    @Test
    public void jmsExceptionWhileDisconnecting() throws Exception {
        this.doDisconnectExceptionTest((Exception)new JMSException("Test exception"));
    }

    @Test
    public void undeclaredThrowableExceptionWhileDisconnecting() throws Exception {
        this.doDisconnectExceptionTest(new UndeclaredThrowableException(new RuntimeException((Throwable)new JMSException("Test exception"))));
    }

    @Test(expected=RuntimeException.class)
    public void otherExceptionWhileDisconnecting() throws Exception {
        this.doDisconnectExceptionTest(new RuntimeException("Test exception"));
    }
}

