/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms.integration;

import javax.jms.Message;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Test;
import org.mule.RequestContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.transformer.AbstractMessageTransformer;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.transport.jms.integration.AbstractJmsFunctionalTestCase;
import org.mule.transport.jms.integration.SessionEnabledObjectToJMSMessage;

public class JmsMessageAwareTransformersMule2685TestCase
extends AbstractJmsFunctionalTestCase {
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private Session session = null;

    protected String getConfigFile() {
        return "integration/jms-transformers.xml";
    }

    @Override
    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.session = this.getConnection(false, false).createSession(false, 1);
    }

    @Override
    protected void doTearDown() throws Exception {
        RequestContext.setEvent(null);
        if (this.session != null) {
            this.session.close();
            this.session = null;
        }
    }

    @Test
    public void testMessageAwareTransformerChainedWithObjectToJMSMessage() throws Exception {
        RequestContext.setEvent((MuleEvent)JmsMessageAwareTransformersMule2685TestCase.getTestEvent((Object)"test"));
        MuleMessage message = this.getTestMuleMessage("This is a test TextMessage");
        SetTestRecipientsTransformer trans = new SetTestRecipientsTransformer();
        MuleMessage result1 = (MuleMessage)trans.transform(message);
        Assert.assertEquals((Object)"vm://recipient1, vm://recipient1, vm://recipient3", (Object)result1.getOutboundProperty("recipients"));
        SessionEnabledObjectToJMSMessage trans2 = new SessionEnabledObjectToJMSMessage(this.session);
        Message result2 = (Message)trans2.transform(result1);
        Assert.assertTrue((String)"Transformed object should be a TextMessage", (boolean)(result2 instanceof TextMessage));
        Assert.assertEquals((Object)"This is a test TextMessage", (Object)((TextMessage)result2).getText());
        Assert.assertEquals((Object)"vm://recipient1, vm://recipient1, vm://recipient3", (Object)result2.getStringProperty("recipients"));
    }

    private class SetTestRecipientsTransformer
    extends AbstractMessageTransformer {
        public SetTestRecipientsTransformer() {
            this.registerSourceType(DataTypeFactory.MULE_MESSAGE);
        }

        public Object transformMessage(MuleMessage message, String outputEncoding) {
            String recipients = "vm://recipient1, vm://recipient1, vm://recipient3";
            this.logger.debug((Object)("Setting recipients to '" + recipients + "'"));
            message.setOutboundProperty("recipients", (Object)recipients);
            return message;
        }
    }
}

