/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms.integration;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.object.IsCompatibleType;
import org.junit.Test;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.processor.MessageProcessor;
import org.mule.tck.functional.FlowAssert;
import org.mule.transport.jms.integration.AbstractJmsFunctionalTestCase;

public class JmsObjectToMessageDataTypeTransformerTestCase
extends AbstractJmsFunctionalTestCase {
    protected String getConfigFile() {
        return "integration/jms-object-to-message-transformer-data-type-test-case.xml";
    }

    @Test
    public void testDataTypeTransformation() throws Exception {
        AbstractJmsFunctionalTestCase.NonTransactedScenario sendTextMessageScenario = new AbstractJmsFunctionalTestCase.NonTransactedScenario(){

            @Override
            public void send(Session session, MessageProducer producer) throws JMSException {
                producer.send((Message)session.createTextMessage("INPUT MESSAGE"));
            }
        };
        this.send(sendTextMessageScenario);
        FlowAssert.verify((String)"message-to-string-flow");
    }

    public static class CheckTextMessageType
    implements MessageProcessor {
        public MuleEvent process(MuleEvent event) throws MuleException {
            MatcherAssert.assertThat((Object)event.getMessage().getDataType().getType(), (Matcher)IsCompatibleType.typeCompatibleWith(TextMessage.class));
            return event;
        }
    }
}

