/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms.integration;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.transport.PropertyScope;
import org.mule.tck.AbstractServiceAndFlowTestCase;

public class JmsResponseElementTestCase
extends AbstractServiceAndFlowTestCase {
    public static final String MESSAGE = "A Message";
    public static final String EXPECTED_MODIFIED_MESSAGE = "A Message jms flow content";
    public static final int TIMEOUT = 3000;
    public static final int TINY_TIMEOUT = 300;

    public JmsResponseElementTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "integration/jms-response-element-config-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "integration/jms-response-element-config-flow.xml"});
    }

    @Test
    public void testOutboundEndpointResponse() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send("vm://vminbound", (Object)"some message", null);
        Assert.assertThat((Object)response.getPayloadAsString(), (Matcher)Is.is((Object)EXPECTED_MODIFIED_MESSAGE));
        Assert.assertThat((Object)response.getProperty("test", PropertyScope.INBOUND), (Matcher)Is.is((Object)"test"));
        Assert.assertThat((Object)response.getExceptionPayload(), (Matcher)IsNull.nullValue());
    }

    @Test
    public void testInboundEndpointResponse() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send("vm://vminbound2", (Object)MESSAGE, null);
        Assert.assertThat((Object)response.getPayloadAsString(), (Matcher)Is.is((Object)EXPECTED_MODIFIED_MESSAGE));
        Assert.assertThat((Object)response.getExceptionPayload(), (Matcher)IsNull.nullValue());
    }

    @Test
    public void testInboundEndpointResponseWithReplyTo() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        HashMap<String, String> messageProperties = new HashMap<String, String>();
        String replyToUri = "jms://out2";
        messageProperties.put("MULE_REPLYTO", replyToUri);
        client.dispatch("jms://out", (Object)MESSAGE, messageProperties);
        MuleMessage response = client.request(replyToUri, 3000L);
        Assert.assertThat((Object)response.getPayloadAsString(), (Matcher)Is.is((Object)EXPECTED_MODIFIED_MESSAGE));
        Assert.assertThat((Object)response.getExceptionPayload(), (Matcher)IsNull.nullValue());
        response = client.request(replyToUri, 300L);
        Assert.assertThat((Object)response, (Matcher)IsNull.nullValue());
    }

    @Test
    public void testInboundEndpointOneWay() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send("jms://in3", (Object)MESSAGE, null);
        Assert.assertThat((Object)response.getPayloadAsString(), (Matcher)Is.is((Object)EXPECTED_MODIFIED_MESSAGE));
        Assert.assertThat((Object)response.getExceptionPayload(), (Matcher)IsNull.nullValue());
    }
}

