/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms.integration;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleMessage;
import org.mule.tck.functional.FlowAssert;
import org.mule.transport.NullPayload;
import org.mule.transport.jms.integration.AbstractJmsFunctionalTestCase;

public class JmsTemporaryReplyToTestCase
extends AbstractJmsFunctionalTestCase {
    private static String ECHO_FLOW_NAME = "EchoFlow";

    protected String getConfigFile() {
        return "integration/jms-temporary-replyTo.xml";
    }

    @Test
    public void testReplyEnabledSync() throws Exception {
        MuleMessage response = this.runFlow("JMSService1SyncFixed", "Test Message").getMessage();
        FlowAssert.verify((String)"JMSService1SyncFixed");
        this.assertEchoResponse(response);
    }

    @Test
    public void testReplyEnabledSyncTimeout() throws Exception {
        MuleMessage response = this.runFlow("JMSService1SyncTimeoutFixed", "Test Message").getMessage();
        FlowAssert.verify((String)"JMSService1SyncTimeoutFixed");
        this.assertNullPayloadResponse(response);
    }

    @Test
    public void testReplyEnabledNonBlocking() throws Exception {
        MuleMessage response = this.runFlowNonBlocking("JMSService1NonBlockingFixed", "Test Message").getMessage();
        FlowAssert.verify((String)"JMSService1NonBlockingFixed");
        this.assertEchoResponse(response);
    }

    @Test
    public void testReplyEnabledNonBlockingTimeout() throws Exception {
        MuleMessage response = this.runFlowNonBlocking("JMSService1NonBlockingTimeoutFixed", "Test Message").getMessage();
        FlowAssert.verify((String)"JMSService1NonBlockingTimeoutFixed");
        this.assertNullPayloadResponse(response);
    }

    @Test
    public void testTemporaryReplyEnabledSync() throws Exception {
        MuleMessage response = this.runFlow("JMSService1Sync", "Test Message").getMessage();
        FlowAssert.verify((String)"JMSService1Sync");
        this.assertEchoResponse(response);
    }

    @Test
    public void testTemporaryReplyEnabledSyncTimeout() throws Exception {
        MuleMessage response = this.runFlow("JMSService1SyncTimeout", "Test Message").getMessage();
        FlowAssert.verify((String)"JMSService1SyncTimeout");
        this.assertNullPayloadResponse(response);
    }

    @Test
    public void testTemporaryReplyEnabledNonBlocking() throws Exception {
        MuleMessage response = this.runFlowNonBlocking("JMSService1NonBlocking", "Test Message").getMessage();
        FlowAssert.verify((String)"JMSService1NonBlocking");
        this.assertEchoResponse(response);
    }

    @Test
    public void testTemporaryReplyEnabledNonBlockingTimeout() throws Exception {
        MuleMessage response = this.runFlowNonBlocking("JMSService1NonBlockingTimeout", "Test Message").getMessage();
        FlowAssert.verify((String)"JMSService1NonBlockingTimeout");
        Assert.assertEquals((Object)NullPayload.getInstance(), (Object)response.getPayload());
    }

    @Test
    public void testTemporaryReplyDisabledSync() throws Exception {
        Assert.assertThat((Object)this.runFlow("JMSService2Sync"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testDisableTemporaryReplyOnTheConnector() throws Exception {
        MuleMessage response = this.runFlow("JMSService3", "Test Message").getMessage();
        Assert.assertEquals((Object)"Test Message", (Object)response.getPayload());
    }

    @Test
    public void testExplicitReplyToAsyncSet() throws Exception {
        MuleMessage response = this.runFlow("JMSService4", "Test Message").getMessage();
        this.assertEchoResponse(response);
    }

    private void assertEchoResponse(MuleMessage response) throws Exception {
        Assert.assertThat((Object)response.getPayloadAsString(), (Matcher)CoreMatchers.equalTo((Object)("Test Message " + ECHO_FLOW_NAME)));
    }

    private void assertNullPayloadResponse(MuleMessage response) {
        Assert.assertThat((Object)response.getPayload(), (Matcher)CoreMatchers.is((Object)NullPayload.getInstance()));
    }
}

