/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms.integration.transactions.local;

import javax.jms.JMSException;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.transport.DispatchException;
import org.mule.construct.Flow;
import org.mule.transport.jms.integration.AbstractJmsFunctionalTestCase;

public class JmsSingleTransactionTransactionalElementTestCase
extends AbstractJmsFunctionalTestCase {
    protected String getConfigFile() {
        return "integration/transactions/local/jms-single-tx-transactional.xml";
    }

    @Before
    public void setUpTest() throws JMSException {
        this.purge("out1");
        this.purge("out2");
        this.purge("out3");
    }

    @Test
    public void testTransactional() throws Exception {
        Flow flow = (Flow)this.getFlowConstruct("transactional");
        MuleEvent event = JmsSingleTransactionTransactionalElementTestCase.getTestEvent((Object)"message", (FlowConstruct)flow);
        flow.process(event);
        MuleMessage message1 = muleContext.getClient().request("out1", 1000L);
        MuleMessage message2 = muleContext.getClient().request("out2", 1000L);
        Assert.assertThat((Object)message1, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)message2, (Matcher)IsNull.notNullValue());
    }

    @Test
    public void testTransactionalFailInTheMiddle() throws Exception {
        Flow flow = (Flow)this.getFlowConstruct("transactionalFailInTheMiddle");
        MuleEvent event = JmsSingleTransactionTransactionalElementTestCase.getTestEvent((Object)"message", (FlowConstruct)flow);
        try {
            flow.process(event);
        }
        catch (Exception exception) {
            // empty catch block
        }
        MuleMessage message1 = muleContext.getClient().request("out1", 1000L);
        MuleMessage message2 = muleContext.getClient().request("out2", 1000L);
        Assert.assertThat((Object)message1, (Matcher)IsNull.nullValue());
        Assert.assertThat((Object)message2, (Matcher)IsNull.nullValue());
    }

    @Test
    public void testTransactionalFailAtEnd() throws Exception {
        Flow flow = (Flow)this.getFlowConstruct("transactionalFailAtEnd");
        MuleEvent event = JmsSingleTransactionTransactionalElementTestCase.getTestEvent((Object)"message", (FlowConstruct)flow);
        try {
            flow.process(event);
        }
        catch (Exception exception) {
            // empty catch block
        }
        MuleMessage message1 = muleContext.getClient().request("out1", 1000L);
        MuleMessage message2 = muleContext.getClient().request("out2", 1000L);
        Assert.assertThat((Object)message1, (Matcher)IsNull.nullValue());
        Assert.assertThat((Object)message2, (Matcher)IsNull.nullValue());
    }

    @Test
    public void testTransactionalFailAfterEnd() throws Exception {
        Flow flow = (Flow)this.getFlowConstruct("transactionalFailAfterEnd");
        MuleEvent event = JmsSingleTransactionTransactionalElementTestCase.getTestEvent((Object)"message", (FlowConstruct)flow);
        try {
            flow.process(event);
        }
        catch (Exception exception) {
            // empty catch block
        }
        MuleMessage message1 = muleContext.getClient().request("out1", 1000L);
        MuleMessage message2 = muleContext.getClient().request("out2", 1000L);
        Assert.assertThat((Object)message1, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)message2, (Matcher)IsNull.notNullValue());
    }

    @Test
    public void testTransactionalFailInTheMiddleWithCatchExceptionStrategy() throws Exception {
        Flow flow = (Flow)this.getFlowConstruct("transactionalFailInTheMiddleWithCatchExceptionStrategy");
        MuleEvent event = JmsSingleTransactionTransactionalElementTestCase.getTestEvent((Object)"message", (FlowConstruct)flow);
        flow.process(event);
        MuleMessage message1 = muleContext.getClient().request("out1", 1000L);
        MuleMessage message2 = muleContext.getClient().request("out2", 1000L);
        Assert.assertThat((Object)message1, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)message2, (Matcher)IsNull.nullValue());
    }

    @Test
    public void testTransactionalFailAtEndWithCatchExceptionStrategy() throws Exception {
        Flow flow = (Flow)this.getFlowConstruct("transactionalFailAtEndWithCatchExceptionStrategy");
        MuleEvent event = JmsSingleTransactionTransactionalElementTestCase.getTestEvent((Object)"message", (FlowConstruct)flow);
        flow.process(event);
        MuleMessage message1 = muleContext.getClient().request("out1", 1000L);
        MuleMessage message2 = muleContext.getClient().request("out2", 1000L);
        Assert.assertThat((Object)message1, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)message2, (Matcher)IsNull.notNullValue());
    }

    @Test
    public void testTransactionalFailsWithAnotherResourceType() throws Exception {
        Flow flow = (Flow)this.getFlowConstruct("transactionalFailsWithAnotherResourceType");
        MuleEvent event = JmsSingleTransactionTransactionalElementTestCase.getTestEvent((Object)"message", (FlowConstruct)flow);
        try {
            flow.process(event);
            Assert.fail((String)"DispatchException should be thrown");
        }
        catch (DispatchException dispatchException) {
            // empty catch block
        }
        MuleMessage message1 = muleContext.getClient().request("out1", 1000L);
        MuleMessage message2 = muleContext.getClient().request("out2", 1000L);
        Assert.assertThat((Object)message1, (Matcher)IsNull.nullValue());
        Assert.assertThat((Object)message2, (Matcher)IsNull.nullValue());
    }

    @Test
    public void testTransactionalDoesntFailWithAnotherResourceType() throws Exception {
        Flow flow = (Flow)this.getFlowConstruct("transactionalDoesntFailWithAnotherResourceType");
        MuleEvent event = JmsSingleTransactionTransactionalElementTestCase.getTestEvent((Object)"message", (FlowConstruct)flow);
        flow.process(event);
        MuleMessage message1 = muleContext.getClient().request("out1", 1000L);
        MuleMessage message2 = muleContext.getClient().request("out2", 1000L);
        MuleMessage message3 = muleContext.getClient().request("out3", 1000L);
        Assert.assertThat((Object)message1, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)message2, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)message3, (Matcher)IsNull.notNullValue());
    }

    @Test
    public void testTransactionalWithAnotherResourceTypeAndExceptionAtEnd() throws Exception {
        Flow flow = (Flow)this.getFlowConstruct("transactionalWithAnotherResourceTypeAndExceptionAtEnd");
        MuleEvent event = JmsSingleTransactionTransactionalElementTestCase.getTestEvent((Object)"message", (FlowConstruct)flow);
        try {
            flow.process(event);
        }
        catch (Exception exception) {
            // empty catch block
        }
        MuleMessage message1 = muleContext.getClient().request("out1", 1000L);
        MuleMessage message2 = muleContext.getClient().request("out2", 1000L);
        MuleMessage message3 = muleContext.getClient().request("out3", 1000L);
        Assert.assertThat((Object)message1, (Matcher)IsNull.nullValue());
        Assert.assertThat((Object)message2, (Matcher)IsNull.nullValue());
        Assert.assertThat((Object)message3, (Matcher)IsNull.notNullValue());
    }

    @Test
    public void testNestedTransactional() throws Exception {
        Flow flow = (Flow)this.getFlowConstruct("nestedTransactional");
        MuleEvent event = JmsSingleTransactionTransactionalElementTestCase.getTestEvent((Object)"message", (FlowConstruct)flow);
        flow.process(event);
        MuleMessage message1 = muleContext.getClient().request("out1", 1000L);
        MuleMessage message2 = muleContext.getClient().request("out2", 1000L);
        Assert.assertThat((Object)message1, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)message2, (Matcher)IsNull.notNullValue());
    }

    @Test
    public void testNestedTransactionalFail() throws Exception {
        Flow flow = (Flow)this.getFlowConstruct("nestedTransactionalFail");
        MuleEvent event = JmsSingleTransactionTransactionalElementTestCase.getTestEvent((Object)"message", (FlowConstruct)flow);
        try {
            flow.process(event);
        }
        catch (Exception exception) {
            // empty catch block
        }
        MuleMessage message1 = muleContext.getClient().request("out1", 1000L);
        MuleMessage message2 = muleContext.getClient().request("out2", 1000L);
        Assert.assertThat((Object)message1, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)message2, (Matcher)IsNull.nullValue());
    }

    @Test
    public void testNestedTransactionalFailWithCatch() throws Exception {
        Flow flow = (Flow)this.getFlowConstruct("nestedTransactionalFailWithCatch");
        MuleEvent event = JmsSingleTransactionTransactionalElementTestCase.getTestEvent((Object)"message", (FlowConstruct)flow);
        flow.process(event);
        MuleMessage message1 = muleContext.getClient().request("out1", 1000L);
        MuleMessage message2 = muleContext.getClient().request("out2", 1000L);
        Assert.assertThat((Object)message1, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)message2, (Matcher)IsNull.notNullValue());
    }

    @Test
    public void testNestedTransactionalWithBeginOrJoin() throws Exception {
        Flow flow = (Flow)this.getFlowConstruct("nestedTransactionalWithBeginOrJoin");
        MuleEvent event = JmsSingleTransactionTransactionalElementTestCase.getTestEvent((Object)"message", (FlowConstruct)flow);
        flow.process(event);
        MuleMessage message1 = muleContext.getClient().request("out1", 1000L);
        MuleMessage message2 = muleContext.getClient().request("out2", 1000L);
        Assert.assertThat((Object)message1, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)message2, (Matcher)IsNull.notNullValue());
    }

    @Test
    public void testNestedTransactionalWithBeginOrJoinFail() throws Exception {
        Flow flow = (Flow)this.getFlowConstruct("nestedTransactionalWithBeginOrJoinFail");
        MuleEvent event = JmsSingleTransactionTransactionalElementTestCase.getTestEvent((Object)"message", (FlowConstruct)flow);
        try {
            flow.process(event);
        }
        catch (Exception exception) {
            // empty catch block
        }
        MuleMessage message1 = muleContext.getClient().request("out1", 1000L);
        MuleMessage message2 = muleContext.getClient().request("out2", 1000L);
        Assert.assertThat((Object)message1, (Matcher)IsNull.nullValue());
        Assert.assertThat((Object)message2, (Matcher)IsNull.nullValue());
    }

    @Test
    public void testNestedTransactionalWithBeginOrJoinFailWithCatch() throws Exception {
        Flow flow = (Flow)this.getFlowConstruct("nestedTransactionalWithBeginOrJoinFailWithCatch");
        MuleEvent event = JmsSingleTransactionTransactionalElementTestCase.getTestEvent((Object)"message", (FlowConstruct)flow);
        flow.process(event);
        MuleMessage message1 = muleContext.getClient().request("out1", 1000L);
        MuleMessage message2 = muleContext.getClient().request("out2", 1000L);
        Assert.assertThat((Object)message1, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)message2, (Matcher)IsNull.notNullValue());
    }

    @Test
    public void testNestedTransactionalWithBeginOrJoinFailWithCatchAndRollback() throws Exception {
        Flow flow = (Flow)this.getFlowConstruct("nestedTransactionalWithBeginOrJoinFailWithCatchAndRollback");
        MuleEvent event = JmsSingleTransactionTransactionalElementTestCase.getTestEvent((Object)"message", (FlowConstruct)flow);
        flow.process(event);
        MuleMessage message1 = muleContext.getClient().request("out1", 1000L);
        MuleMessage message2 = muleContext.getClient().request("out2", 1000L);
        Assert.assertThat((Object)message1, (Matcher)IsNull.nullValue());
        Assert.assertThat((Object)message2, (Matcher)IsNull.nullValue());
    }
}

