/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms;

import java.util.Collection;
import java.util.LinkedList;
import javax.jms.ConnectionFactory;
import org.mule.api.MuleContext;
import org.mule.transport.jms.CachingConnectionFactoryDecorator;
import org.mule.transport.jms.ConnectionFactoryDecorator;
import org.mule.transport.jms.DefaultConnectionFactoryDecorator;
import org.mule.transport.jms.JmsConnector;

public class CompositeConnectionFactoryDecorator
implements ConnectionFactoryDecorator {
    private LinkedList<ConnectionFactoryDecorator> decorators = new LinkedList();

    public CompositeConnectionFactoryDecorator() {
        this.decorators.add(new DefaultConnectionFactoryDecorator());
        this.decorators.add(new CachingConnectionFactoryDecorator());
    }

    @Override
    public ConnectionFactory decorate(ConnectionFactory connectionFactory, JmsConnector jmsConnector, MuleContext mulecontext) {
        for (ConnectionFactoryDecorator decorator : this.decorators) {
            if (!decorator.appliesTo(connectionFactory, mulecontext)) continue;
            return decorator.decorate(connectionFactory, jmsConnector, mulecontext);
        }
        return connectionFactory;
    }

    @Override
    public boolean appliesTo(ConnectionFactory connectionFactory, MuleContext muleContext) {
        return true;
    }

    public void init(MuleContext muleContext) {
        Collection connectionFactoryDecorators = muleContext.getRegistry().lookupObjects(ConnectionFactoryDecorator.class);
        for (ConnectionFactoryDecorator connectionFactoryDecorator : connectionFactoryDecorators) {
            this.decorators.addFirst(connectionFactoryDecorator);
        }
    }
}

