/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms;

import java.lang.reflect.Field;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnectionFactory;
import org.mule.api.Closeable;
import org.mule.api.MuleException;
import org.mule.api.lifecycle.Disposable;
import org.springframework.jms.connection.CachingConnectionFactory;
import org.springframework.jms.connection.SingleConnectionFactory;

public class CustomCachingConnectionFactory
extends CachingConnectionFactory
implements Closeable,
Disposable {
    private final String username;
    private final String password;

    public CustomCachingConnectionFactory(ConnectionFactory targetConnectionFactory, String username, String password) {
        super(targetConnectionFactory);
        this.username = username;
        this.password = password;
    }

    public Connection createConnection(String username, String password) throws JMSException {
        throw new IllegalStateException("CustomCachingConnectionFactory does not support creating a connection with username and password. Provide the desired username and password when the instance is defined");
    }

    protected Connection doCreateConnection() throws JMSException {
        if (this.username == null && this.password == null) {
            return super.doCreateConnection();
        }
        ConnectionFactory cf = this.getTargetConnectionFactory();
        if (Boolean.FALSE.equals(this.getPubSubMode()) && cf instanceof QueueConnectionFactory) {
            return ((QueueConnectionFactory)cf).createQueueConnection(this.username, this.password);
        }
        if (Boolean.TRUE.equals(this.getPubSubMode()) && cf instanceof TopicConnectionFactory) {
            return ((TopicConnectionFactory)cf).createTopicConnection(this.username, this.password);
        }
        return this.getTargetConnectionFactory().createConnection(this.username, this.password);
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    private boolean getPubSubMode() {
        try {
            Field pubSubModeField = SingleConnectionFactory.class.getDeclaredField("pubSubMode");
            pubSubModeField.setAccessible(true);
            Object value = pubSubModeField.get((Object)this);
            return value == null ? false : (Boolean)value;
        }
        catch (Exception e) {
            throw new java.lang.IllegalStateException("Unable to determine value of pubSubMode field", e);
        }
    }

    public void close() throws MuleException {
        this.resetConnection();
    }

    public void dispose() {
        this.destroy();
    }
}

